/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.type.StandardBasicTypes;

public class DerbyConcatEmulation
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public DerbyConcatEmulation() {
        super("concat", StandardArgumentsValidators.min(1), StandardFunctionReturnTypeResolvers.invariant(StandardBasicTypes.STRING));
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> arguments, SqlAstWalker walker) {
        int numberOfArguments = arguments.size();
        if (numberOfArguments > 1) {
            sqlAppender.appendSql("(");
        }
        for (int i = 0; i < numberOfArguments; ++i) {
            boolean param;
            SqlAstNode argument = arguments.get(i);
            if (i > 0) {
                sqlAppender.appendSql("||");
            }
            if (param = argument instanceof JdbcParameter) {
                sqlAppender.appendSql("cast(");
            }
            argument.accept(walker);
            if (!param) continue;
            sqlAppender.appendSql(" as long varchar)");
        }
        if (numberOfArguments > 1) {
            sqlAppender.appendSql(")");
        }
    }

    @Override
    public String getArgumentListSignature() {
        return "(string0[, string1[, ...]])";
    }
}

