/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Arrays;
import java.util.List;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class InsertSubstringOverlayEmulation
extends AbstractSqmFunctionDescriptor {
    public InsertSubstringOverlayEmulation() {
        super("overlay", StandardArgumentsValidators.between(3, 4), StandardFunctionReturnTypeResolvers.invariant(StandardBasicTypes.STRING));
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<SqmTypedNode<?>> arguments, AllowableFunctionReturnType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        BasicType intType = typeConfiguration.getBasicTypeForJavaType(Integer.class);
        SqmTypedNode<?> string = arguments.get(0);
        SqmTypedNode<?> replacement = arguments.get(1);
        SqmTypedNode<?> start = arguments.get(2);
        SqmTypedNode<?> length = arguments.size() > 3 ? arguments.get(3) : queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("length").generateSqmExpression(replacement, intType, queryEngine, typeConfiguration);
        SqmFunctionDescriptor insert = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("insert");
        if (insert != null) {
            return insert.generateSqmExpression(Arrays.asList(string, start, length, replacement), impliedResultType, queryEngine, typeConfiguration);
        }
        SqmFunctionDescriptor substring = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("substring");
        SqmFunctionDescriptor concat = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("concat");
        SqmLiteral<Integer> one = new SqmLiteral<Integer>(1, intType, queryEngine.getCriteriaBuilder());
        SqmBinaryArithmetic startPlusLength = new SqmBinaryArithmetic(BinaryArithmeticOperator.ADD, (SqmExpression)start, (SqmExpression)length, intType, (NodeBuilder)queryEngine.getCriteriaBuilder());
        SqmBinaryArithmetic startMinusOne = new SqmBinaryArithmetic(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)start, one, intType, (NodeBuilder)queryEngine.getCriteriaBuilder());
        return concat.generateSqmExpression(Arrays.asList(substring.generateSqmExpression(Arrays.asList(string, one, startMinusOne), impliedResultType, queryEngine, typeConfiguration), replacement, substring.generateSqmExpression(Arrays.asList(string, startPlusLength), impliedResultType, queryEngine, typeConfiguration)), impliedResultType, queryEngine, typeConfiguration);
    }

    @Override
    public String getArgumentListSignature() {
        return "(string placing replacement from start[ for length])";
    }
}

