/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class TimestampaddFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private Dialect dialect;

    public TimestampaddFunction(Dialect dialect) {
        super("timestampadd", StandardArgumentsValidators.exactly(3), StandardFunctionReturnTypeResolvers.useArgType(3));
        this.dialect = dialect;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> arguments, SqlAstWalker walker) {
        DurationUnit field = (DurationUnit)arguments.get(0);
        Expression to = (Expression)arguments.get(2);
        String pattern = this.dialect.timestampaddPattern(field.getUnit(), TypeConfiguration.isSqlTimestampType(to.getExpressionType()));
        new PatternRenderer(pattern).render(sqlAppender, arguments, walker);
    }

    public SelfRenderingFunctionSqlAstExpression expression(AllowableFunctionReturnType<?> impliedResultType, SqlAstNode ... sqlAstArguments) {
        Expression to = (Expression)sqlAstArguments[2];
        return new SelfRenderingFunctionSqlAstExpression(this::render, Arrays.asList(sqlAstArguments), impliedResultType, to.getExpressionType());
    }

    @Override
    public String getArgumentListSignature() {
        return "(field, magnitude, datetime)";
    }
}

