/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.pagination.SQLServer2005LimitHandler;

public class SQLServer2012LimitHandler
extends OffsetFetchLimitHandler {
    public static final SQLServer2012LimitHandler INSTANCE = new SQLServer2012LimitHandler();

    public SQLServer2012LimitHandler() {
        super(true);
    }

    @Override
    void begin(String sql, StringBuilder offsetFetch, boolean hasFirstRow, boolean hasMaxRows) {
        if (SQLServer2005LimitHandler.Keyword.ORDER_BY.rootOffset(sql) <= 0) {
            offsetFetch.append(" order by ");
            int from = SQLServer2005LimitHandler.Keyword.FROM.rootOffset(sql);
            if (from > 0) {
                offsetFetch.append("zero_");
            } else {
                offsetFetch.append("1");
            }
        }
        if (!hasFirstRow) {
            offsetFetch.append(" offset 0 rows");
        }
    }

    @Override
    String insert(String offsetFetch, String sql) {
        int from;
        String result = super.insert(offsetFetch, sql);
        if (SQLServer2005LimitHandler.Keyword.ORDER_BY.rootOffset(sql) <= 0 && (from = SQLServer2005LimitHandler.Keyword.FROM.rootOffset(sql)) > 0) {
            return new StringBuilder(result).insert(from, ", 0 as zero_ ").toString();
        }
        return result;
    }
}

