/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.sequence;

import org.hibernate.MappingException;

public interface SequenceSupport {
    default public boolean supportsSequences() {
        return true;
    }

    default public boolean supportsPooledSequences() {
        return this.supportsSequences();
    }

    public String getSelectSequenceNextValString(String var1) throws MappingException;

    default public String getSequenceNextValString(String sequenceName) throws MappingException {
        return "select " + this.getSelectSequenceNextValString(sequenceName) + this.getFromDual();
    }

    default public String getFromDual() {
        return "";
    }

    default public String getSequenceNextValString(String sequenceName, int increment) throws MappingException {
        return this.getSequenceNextValString(sequenceName);
    }

    default public String[] getCreateSequenceStrings(String sequenceName, int initialValue, int incrementSize) throws MappingException {
        return new String[]{this.getCreateSequenceString(sequenceName, initialValue, incrementSize)};
    }

    default public String getCreateSequenceString(String sequenceName) throws MappingException {
        return "create sequence " + sequenceName;
    }

    default public String getCreateSequenceString(String sequenceName, int initialValue, int incrementSize) throws MappingException {
        if (incrementSize == 0) {
            throw new MappingException("Unable to create the sequence [" + sequenceName + "]: the increment size must not be 0");
        }
        return this.getCreateSequenceString(sequenceName) + this.startingValue(initialValue, incrementSize) + " start with " + initialValue + " increment by " + incrementSize;
    }

    default public String[] getDropSequenceStrings(String sequenceName) throws MappingException {
        return new String[]{this.getDropSequenceString(sequenceName)};
    }

    default public String getDropSequenceString(String sequenceName) throws MappingException {
        return "drop sequence " + sequenceName;
    }

    default public boolean sometimesNeedsStartingValue() {
        return false;
    }

    default public String startingValue(int initialValue, int incrementSize) {
        if (this.sometimesNeedsStartingValue()) {
            if (incrementSize > 0 && initialValue <= 0) {
                return " minvalue " + initialValue;
            }
            if (incrementSize < 0 && initialValue >= 0) {
                return " maxvalue " + initialValue;
            }
        }
        return "";
    }
}

