/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowReader;

public abstract class AbstractScrollableResults<R>
implements ScrollableResultsImplementor<R> {
    private final JdbcValues jdbcValues;
    private final JdbcValuesSourceProcessingOptions processingOptions;
    private final JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState;
    private final RowProcessingStateStandardImpl rowProcessingState;
    private final RowReader<R> rowReader;
    private final SharedSessionContractImplementor persistenceContext;
    private boolean closed;

    public AbstractScrollableResults(JdbcValues jdbcValues, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader, SharedSessionContractImplementor persistenceContext) {
        this.jdbcValues = jdbcValues;
        this.processingOptions = processingOptions;
        this.jdbcValuesSourceProcessingState = jdbcValuesSourceProcessingState;
        this.rowProcessingState = rowProcessingState;
        this.rowReader = rowReader;
        this.persistenceContext = persistenceContext;
    }

    @Override
    public final R get() throws HibernateException {
        if (this.closed) {
            throw new IllegalStateException("ScrollableResults is closed");
        }
        return this.getCurrentRow();
    }

    protected abstract R getCurrentRow();

    protected JdbcValues getJdbcValues() {
        return this.jdbcValues;
    }

    protected JdbcValuesSourceProcessingOptions getProcessingOptions() {
        return this.processingOptions;
    }

    protected JdbcValuesSourceProcessingStateStandardImpl getJdbcValuesSourceProcessingState() {
        return this.jdbcValuesSourceProcessingState;
    }

    protected RowProcessingStateStandardImpl getRowProcessingState() {
        return this.rowProcessingState;
    }

    protected RowReader<R> getRowReader() {
        return this.rowReader;
    }

    protected SharedSessionContractImplementor getPersistenceContext() {
        return this.persistenceContext;
    }

    protected void afterScrollOperation() {
        this.getPersistenceContext().afterScrollOperation();
    }

    @Override
    public final void close() {
        if (this.closed) {
            return;
        }
        this.getJdbcValues().finishUp(this.persistenceContext);
        this.getPersistenceContext().getJdbcCoordinator().afterStatementExecution();
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

