/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.PessimisticLockScope;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cfg.BaselineSessionEventsListenerBuilder;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.ClearEventListener;
import org.hibernate.event.spi.DeleteEventListener;
import org.hibernate.event.spi.DirtyCheckEventListener;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.EvictEventListener;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.InitializeCollectionEventListener;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.LockEventListener;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.RefreshEventListener;
import org.hibernate.event.spi.ReplicateEventListener;
import org.hibernate.event.spi.ResolveNaturalIdEventListener;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.internal.ConnectionObserverStatsBridge;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jpa.internal.util.CacheModeHelper;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.jpa.internal.util.LockOptionsHelper;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public final class FastSessionServices {
    final Map<String, Object> defaultSessionProperties;
    final EventListenerGroup<AutoFlushEventListener> eventListenerGroup_AUTO_FLUSH;
    final EventListenerGroup<ClearEventListener> eventListenerGroup_CLEAR;
    final EventListenerGroup<DeleteEventListener> eventListenerGroup_DELETE;
    final EventListenerGroup<DirtyCheckEventListener> eventListenerGroup_DIRTY_CHECK;
    final EventListenerGroup<EvictEventListener> eventListenerGroup_EVICT;
    final EventListenerGroup<FlushEventListener> eventListenerGroup_FLUSH;
    final EventListenerGroup<InitializeCollectionEventListener> eventListenerGroup_INIT_COLLECTION;
    final EventListenerGroup<LoadEventListener> eventListenerGroup_LOAD;
    final EventListenerGroup<LockEventListener> eventListenerGroup_LOCK;
    final EventListenerGroup<MergeEventListener> eventListenerGroup_MERGE;
    final EventListenerGroup<PersistEventListener> eventListenerGroup_PERSIST;
    final EventListenerGroup<PersistEventListener> eventListenerGroup_PERSIST_ONFLUSH;
    final EventListenerGroup<RefreshEventListener> eventListenerGroup_REFRESH;
    final EventListenerGroup<ReplicateEventListener> eventListenerGroup_REPLICATE;
    final EventListenerGroup<ResolveNaturalIdEventListener> eventListenerGroup_RESOLVE_NATURAL_ID;
    final EventListenerGroup<SaveOrUpdateEventListener> eventListenerGroup_SAVE;
    final EventListenerGroup<SaveOrUpdateEventListener> eventListenerGroup_SAVE_UPDATE;
    final EventListenerGroup<SaveOrUpdateEventListener> eventListenerGroup_UPDATE;
    final EventListenerGroup<PostLoadEventListener> eventListenerGroup_POST_LOAD;
    final boolean disallowOutOfTransactionUpdateOperations;
    final boolean useStreamForLobBinding;
    final boolean requiresMultiTenantConnectionProvider;
    final ConnectionProvider connectionProvider;
    final MultiTenantConnectionProvider multiTenantConnectionProvider;
    final ClassLoaderService classLoaderService;
    final TransactionCoordinatorBuilder transactionCoordinatorBuilder;
    final JdbcServices jdbcServices;
    final boolean isJtaTransactionAccessible;
    final CacheMode initialSessionCacheMode;
    final FlushMode initialSessionFlushMode;
    final boolean discardOnClose;
    final BaselineSessionEventsListenerBuilder defaultSessionEventListeners;
    final LockOptions defaultLockOptions;
    private final Dialect dialect;
    private final CacheStoreMode defaultCacheStoreMode;
    private final CacheRetrieveMode defaultCacheRetrieveMode;
    private final ConnectionObserverStatsBridge defaultJdbcObservers;

    FastSessionServices(SessionFactoryImpl sf) {
        Objects.requireNonNull(sf);
        ServiceRegistryImplementor sr = sf.getServiceRegistry();
        JdbcServices jdbcServices = sf.getJdbcServices();
        SessionFactoryOptions sessionFactoryOptions = sf.getSessionFactoryOptions();
        EventListenerRegistry eventListenerRegistry = sr.getService(EventListenerRegistry.class);
        this.eventListenerGroup_AUTO_FLUSH = FastSessionServices.listeners(eventListenerRegistry, EventType.AUTO_FLUSH);
        this.eventListenerGroup_CLEAR = FastSessionServices.listeners(eventListenerRegistry, EventType.CLEAR);
        this.eventListenerGroup_DELETE = FastSessionServices.listeners(eventListenerRegistry, EventType.DELETE);
        this.eventListenerGroup_DIRTY_CHECK = FastSessionServices.listeners(eventListenerRegistry, EventType.DIRTY_CHECK);
        this.eventListenerGroup_EVICT = FastSessionServices.listeners(eventListenerRegistry, EventType.EVICT);
        this.eventListenerGroup_FLUSH = FastSessionServices.listeners(eventListenerRegistry, EventType.FLUSH);
        this.eventListenerGroup_INIT_COLLECTION = FastSessionServices.listeners(eventListenerRegistry, EventType.INIT_COLLECTION);
        this.eventListenerGroup_LOAD = FastSessionServices.listeners(eventListenerRegistry, EventType.LOAD);
        this.eventListenerGroup_LOCK = FastSessionServices.listeners(eventListenerRegistry, EventType.LOCK);
        this.eventListenerGroup_MERGE = FastSessionServices.listeners(eventListenerRegistry, EventType.MERGE);
        this.eventListenerGroup_PERSIST = FastSessionServices.listeners(eventListenerRegistry, EventType.PERSIST);
        this.eventListenerGroup_PERSIST_ONFLUSH = FastSessionServices.listeners(eventListenerRegistry, EventType.PERSIST_ONFLUSH);
        this.eventListenerGroup_REFRESH = FastSessionServices.listeners(eventListenerRegistry, EventType.REFRESH);
        this.eventListenerGroup_REPLICATE = FastSessionServices.listeners(eventListenerRegistry, EventType.REPLICATE);
        this.eventListenerGroup_RESOLVE_NATURAL_ID = FastSessionServices.listeners(eventListenerRegistry, EventType.RESOLVE_NATURAL_ID);
        this.eventListenerGroup_SAVE = FastSessionServices.listeners(eventListenerRegistry, EventType.SAVE);
        this.eventListenerGroup_SAVE_UPDATE = FastSessionServices.listeners(eventListenerRegistry, EventType.SAVE_UPDATE);
        this.eventListenerGroup_UPDATE = FastSessionServices.listeners(eventListenerRegistry, EventType.UPDATE);
        this.eventListenerGroup_POST_LOAD = FastSessionServices.listeners(eventListenerRegistry, EventType.POST_LOAD);
        this.dialect = jdbcServices.getJdbcEnvironment().getDialect();
        this.disallowOutOfTransactionUpdateOperations = !sessionFactoryOptions.isAllowOutOfTransactionUpdateOperations();
        this.useStreamForLobBinding = Environment.useStreamsForBinary() || this.dialect.useInputStreamToInsertBlob();
        this.requiresMultiTenantConnectionProvider = sf.getSettings().getMultiTenancyStrategy().requiresMultiTenantConnectionProvider();
        this.connectionProvider = this.requiresMultiTenantConnectionProvider ? null : sr.getService(ConnectionProvider.class);
        this.multiTenantConnectionProvider = this.requiresMultiTenantConnectionProvider ? sr.getService(MultiTenantConnectionProvider.class) : null;
        this.classLoaderService = sr.getService(ClassLoaderService.class);
        this.transactionCoordinatorBuilder = sr.getService(TransactionCoordinatorBuilder.class);
        this.jdbcServices = sr.getService(JdbcServices.class);
        this.isJtaTransactionAccessible = FastSessionServices.isTransactionAccessible(sf, this.transactionCoordinatorBuilder);
        this.defaultSessionProperties = FastSessionServices.initializeDefaultSessionProperties(sf);
        this.defaultCacheStoreMode = FastSessionServices.determineCacheStoreMode(this.defaultSessionProperties);
        this.defaultCacheRetrieveMode = FastSessionServices.determineCacheRetrieveMode(this.defaultSessionProperties);
        this.initialSessionCacheMode = CacheModeHelper.interpretCacheMode(this.defaultCacheStoreMode, this.defaultCacheRetrieveMode);
        this.discardOnClose = sessionFactoryOptions.isReleaseResourcesOnCloseEnabled();
        this.defaultJdbcObservers = new ConnectionObserverStatsBridge(sf);
        this.defaultSessionEventListeners = sessionFactoryOptions.getBaselineSessionEventsListenerBuilder();
        this.defaultLockOptions = FastSessionServices.initializeDefaultLockOptions(this.defaultSessionProperties);
        this.initialSessionFlushMode = FastSessionServices.initializeDefaultFlushMode(this.defaultSessionProperties);
    }

    private static FlushMode initializeDefaultFlushMode(Map<String, Object> defaultSessionProperties) {
        Object setMode = defaultSessionProperties.get("org.hibernate.flushMode");
        return ConfigurationHelper.getFlushMode(setMode, FlushMode.AUTO);
    }

    private static LockOptions initializeDefaultLockOptions(Map<String, Object> defaultSessionProperties) {
        LockOptions def = new LockOptions();
        LockOptionsHelper.applyPropertiesToLockOptions(defaultSessionProperties, () -> def);
        return def;
    }

    private static <T> EventListenerGroup<T> listeners(EventListenerRegistry elr, EventType<T> type) {
        return elr.getEventListenerGroup(type);
    }

    SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        if (!sqlTypeDescriptor.canBeRemapped()) {
            return sqlTypeDescriptor;
        }
        SqlTypeDescriptor remapped = this.dialect.remapSqlTypeDescriptor(sqlTypeDescriptor);
        return remapped == null ? sqlTypeDescriptor : remapped;
    }

    private static boolean isTransactionAccessible(SessionFactoryImpl sf, TransactionCoordinatorBuilder transactionCoordinatorBuilder) {
        return !sf.getSessionFactoryOptions().getJpaCompliance().isJpaTransactionComplianceEnabled() || !transactionCoordinatorBuilder.isJta() || sf.getSessionFactoryOptions().isJtaTransactionAccessEnabled();
    }

    private static Map<String, Object> initializeDefaultSessionProperties(SessionFactoryImpl sf) {
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("org.hibernate.flushMode", FlushMode.AUTO.name());
        p.put("javax.persistence.lock.scope", PessimisticLockScope.EXTENDED.name());
        p.put("javax.persistence.lock.timeout", -1);
        p.put("javax.persistence.cache.retrieveMode", CacheModeHelper.DEFAULT_RETRIEVE_MODE);
        p.put("javax.persistence.cache.storeMode", CacheModeHelper.DEFAULT_STORE_MODE);
        String[] ENTITY_MANAGER_SPECIFIC_PROPERTIES = new String[]{"javax.persistence.lock.scope", "javax.persistence.lock.timeout", "org.hibernate.flushMode", "javax.persistence.cache.retrieveMode", "javax.persistence.cache.storeMode", "javax.persistence.query.timeout"};
        Map<String, Object> properties = sf.getProperties();
        for (String key : ENTITY_MANAGER_SPECIFIC_PROPERTIES) {
            if (!properties.containsKey(key)) continue;
            p.put(key, properties.get(key));
        }
        return Collections.unmodifiableMap(p);
    }

    CacheStoreMode getCacheStoreMode(Map<String, Object> properties) {
        if (properties == null) {
            return this.defaultCacheStoreMode;
        }
        return FastSessionServices.determineCacheStoreMode(properties);
    }

    CacheRetrieveMode getCacheRetrieveMode(Map<String, Object> properties) {
        if (properties == null) {
            return this.defaultCacheRetrieveMode;
        }
        return FastSessionServices.determineCacheRetrieveMode(properties);
    }

    private static CacheRetrieveMode determineCacheRetrieveMode(Map<String, Object> settings) {
        return (CacheRetrieveMode)settings.get("javax.persistence.cache.retrieveMode");
    }

    private static CacheStoreMode determineCacheStoreMode(Map<String, Object> settings) {
        return (CacheStoreMode)settings.get("javax.persistence.cache.storeMode");
    }

    public ConnectionObserverStatsBridge getDefaultJdbcObserver() {
        return this.defaultJdbcObservers;
    }

    public void firePostLoadEvent(PostLoadEvent postLoadEvent) {
        this.eventListenerGroup_POST_LOAD.fireEventOnEachListener(postLoadEvent, PostLoadEventListener::onPostLoad);
    }
}

