/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.Filter;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.FilterConfiguration;
import org.hibernate.internal.FilterImpl;
import org.hibernate.internal.FilterJdbcParameter;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.sql.Template;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.type.Type;

public class FilterHelper {
    private static final Pattern FILTER_PARAMETER_PATTERN = Pattern.compile(":(\\S+)\\.(\\w+)");
    private final String[] filterNames;
    private final String[] filterConditions;
    private final boolean[] filterAutoAliasFlags;
    private final Map<String, String>[] filterAliasTableMaps;

    public FilterHelper(List<FilterConfiguration> filters, SessionFactoryImplementor factory) {
        int filterCount = filters.size();
        this.filterNames = new String[filterCount];
        this.filterConditions = new String[filterCount];
        this.filterAutoAliasFlags = new boolean[filterCount];
        this.filterAliasTableMaps = new Map[filterCount];
        filterCount = 0;
        for (FilterConfiguration filter : filters) {
            this.filterAutoAliasFlags[filterCount] = false;
            this.filterNames[filterCount] = StringHelper.safeInterning(filter.getName());
            this.filterConditions[filterCount] = StringHelper.safeInterning(filter.getCondition());
            this.filterAliasTableMaps[filterCount] = filter.getAliasTableMap(factory);
            if ((this.filterAliasTableMaps[filterCount].isEmpty() || FilterHelper.isTableFromPersistentClass(this.filterAliasTableMaps[filterCount])) && filter.useAutoAliasInjection()) {
                this.filterConditions[filterCount] = StringHelper.safeInterning(Template.renderWhereStringTemplate(filter.getCondition(), "$FILTER_PLACEHOLDER$", factory.getDialect(), factory.getQueryEngine().getSqmFunctionRegistry()));
                this.filterAutoAliasFlags[filterCount] = true;
            }
            this.filterConditions[filterCount] = StringHelper.safeInterning(StringHelper.replace(this.filterConditions[filterCount], ":", ":" + this.filterNames[filterCount] + "."));
            ++filterCount;
        }
    }

    private static boolean isTableFromPersistentClass(Map<String, String> aliasTableMap) {
        return aliasTableMap.size() == 1 && aliasTableMap.containsKey(null);
    }

    public boolean isAffectedBy(Map<String, Filter> enabledFilters) {
        for (String filterName : this.filterNames) {
            if (!enabledFilters.containsKey(filterName)) continue;
            return true;
        }
        return false;
    }

    public String render(FilterAliasGenerator aliasGenerator, Map<String, Filter> enabledFilters) {
        StringBuilder buffer = new StringBuilder();
        this.render(buffer, aliasGenerator, enabledFilters);
        return buffer.toString();
    }

    public void render(StringBuilder buffer, FilterAliasGenerator aliasGenerator, Map<String, Filter> enabledFilters) {
        if (CollectionHelper.isEmpty(this.filterNames)) {
            return;
        }
        int max = this.filterNames.length;
        for (int i = 0; i < max; ++i) {
            String condition;
            if (!enabledFilters.containsKey(this.filterNames[i]) || !StringHelper.isNotEmpty(condition = this.filterConditions[i])) continue;
            if (buffer.length() > 0) {
                buffer.append(" and ");
            }
            buffer.append(this.render(aliasGenerator, i));
        }
    }

    private String render(FilterAliasGenerator aliasGenerator, int filterIndex) {
        Map<String, String> aliasTableMap = this.filterAliasTableMaps[filterIndex];
        String condition = this.filterConditions[filterIndex];
        if (aliasGenerator == null) {
            return StringHelper.replace(condition, "$FILTER_PLACEHOLDER$.", "");
        }
        if (this.filterAutoAliasFlags[filterIndex]) {
            return StringHelper.replace(condition, "$FILTER_PLACEHOLDER$", aliasGenerator.getAlias(aliasTableMap.get(null)));
        }
        if (FilterHelper.isTableFromPersistentClass(aliasTableMap)) {
            return StringHelper.replace(condition, "{alias}", aliasGenerator.getAlias(aliasTableMap.get(null)));
        }
        for (Map.Entry<String, String> entry : aliasTableMap.entrySet()) {
            condition = StringHelper.replace(condition, "{" + entry.getKey() + "}", aliasGenerator.getAlias(entry.getValue()));
        }
        return condition;
    }

    public static FilterPredicate createFilterPredicate(LoadQueryInfluencers loadQueryInfluencers, Joinable joinable) {
        return FilterHelper.createFilterPredicate(loadQueryInfluencers, joinable, null);
    }

    public static FilterPredicate createFilterPredicate(LoadQueryInfluencers loadQueryInfluencers, Joinable joinable, TableGroup rootTableGroup) {
        String filterFragment = joinable.filterFragment(rootTableGroup, loadQueryInfluencers.getEnabledFilters());
        if (StringHelper.isNotEmpty(filterFragment)) {
            return FilterHelper.doCreateFilterPredicate(filterFragment, loadQueryInfluencers.getEnabledFilters());
        }
        return null;
    }

    public static FilterPredicate createManyToManyFilterPredicate(LoadQueryInfluencers loadQueryInfluencers, CollectionPersister collectionPersister, TableGroup tableGroup) {
        assert (collectionPersister.isManyToMany());
        String filterFragment = collectionPersister.getManyToManyFilterFragment(tableGroup, loadQueryInfluencers.getEnabledFilters());
        if (StringHelper.isNotEmpty(filterFragment)) {
            return FilterHelper.doCreateFilterPredicate(filterFragment, loadQueryInfluencers.getEnabledFilters());
        }
        return null;
    }

    private static FilterPredicate doCreateFilterPredicate(String filterFragment, Map<String, Filter> enabledFilters) {
        Matcher matcher = FILTER_PARAMETER_PATTERN.matcher(filterFragment);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        ArrayList<FilterJdbcParameter> parameters = new ArrayList<FilterJdbcParameter>(matcher.groupCount());
        while (matcher.find()) {
            sb.append(filterFragment, pos, matcher.start());
            pos = matcher.end();
            sb.append("?");
            String filterName = matcher.group(1);
            String parameterName = matcher.group(2);
            FilterImpl enabledFilter = (FilterImpl)enabledFilters.get(filterName);
            if (enabledFilter == null) {
                throw new MappingException(String.format("unknown filter [%s]", filterName));
            }
            Type parameterType = enabledFilter.getFilterDefinition().getParameterType(parameterName);
            if (!(parameterType instanceof JdbcMapping)) {
                throw new MappingException(String.format("parameter [%s] for filter [%s] is not of JdbcMapping type", parameterName, filterName));
            }
            Object parameterValue = enabledFilter.getParameter(parameterName);
            if (parameterValue == null) {
                throw new MappingException(String.format("unknown parameter [%s] for filter [%s]", parameterName, filterName));
            }
            parameters.add(new FilterJdbcParameter((JdbcMapping)((Object)parameterType), parameterValue));
        }
        sb.append(filterFragment, pos, filterFragment.length());
        return new FilterPredicate(sb.toString(), parameters);
    }
}

