/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.AbstractScrollableResults;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowReader;

public class ScrollableResultsImpl<R>
extends AbstractScrollableResults<R> {
    private R currentRow;

    public ScrollableResultsImpl(JdbcValues jdbcValues, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader, SharedSessionContractImplementor persistenceContext) {
        super(jdbcValues, processingOptions, jdbcValuesSourceProcessingState, rowProcessingState, rowReader, persistenceContext);
    }

    @Override
    protected R getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public boolean scroll(int i) {
        throw new NotYetImplementedFor6Exception();
    }

    protected JDBCException convert(SQLException sqle, String message) {
        return this.getPersistenceContext().getJdbcServices().getSqlExceptionHelper().convert(sqle, message);
    }

    @Override
    public boolean first() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public boolean last() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public boolean next() {
        try {
            boolean result = this.getJdbcValues().next(this.getRowProcessingState());
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "could not advance using next()");
        }
    }

    @Override
    public boolean previous() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public void afterLast() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public void beforeFirst() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public boolean isFirst() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public boolean isLast() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public int getRowNumber() throws HibernateException {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public boolean setRowNumber(int rowNumber) throws HibernateException {
        throw new NotYetImplementedFor6Exception();
    }

    private void prepareCurrentRow(boolean underlyingScrollSuccessful) {
        if (!underlyingScrollSuccessful) {
            this.currentRow = null;
            return;
        }
        try {
            this.currentRow = this.getRowReader().readRow(this.getRowProcessingState(), this.getProcessingOptions());
        }
        catch (SQLException e) {
            throw this.convert(e, "Unable to read row as part of ScrollableResult handling");
        }
        this.afterScrollOperation();
    }
}

