/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.CollectionLoader;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;

public class CollectionLoaderSingleKey
implements CollectionLoader {
    private final PluralAttributeMapping attributeMapping;
    private final int keyJdbcCount;
    private final SelectStatement sqlAst;
    private final List<JdbcParameter> jdbcParameters;

    public CollectionLoaderSingleKey(PluralAttributeMapping attributeMapping, LoadQueryInfluencers influencers, SessionFactoryImplementor sessionFactory) {
        this.attributeMapping = attributeMapping;
        this.keyJdbcCount = attributeMapping.getKeyDescriptor().getJdbcTypeCount(sessionFactory.getTypeConfiguration());
        this.jdbcParameters = new ArrayList<JdbcParameter>();
        this.sqlAst = LoaderSelectBuilder.createSelect((Loadable)attributeMapping, null, attributeMapping.getKeyDescriptor(), null, 1, influencers, LockOptions.READ, this.jdbcParameters::add, sessionFactory);
    }

    @Override
    public PluralAttributeMapping getLoadable() {
        return this.getAttributeMapping();
    }

    public PluralAttributeMapping getAttributeMapping() {
        return this.attributeMapping;
    }

    public SelectStatement getSqlAst() {
        return this.sqlAst;
    }

    public List<JdbcParameter> getJdbcParameters() {
        return this.jdbcParameters;
    }

    @Override
    public PersistentCollection load(Object key, final SharedSessionContractImplementor session) {
        final CollectionKey collectionKey = new CollectionKey(this.attributeMapping.getCollectionDescriptor(), key);
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory).translate(this.sqlAst);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.keyJdbcCount);
        jdbcSelect.bindFilterJdbcParameters(jdbcParameterBindings);
        Iterator<JdbcParameter> paramItr = this.jdbcParameters.iterator();
        this.attributeMapping.getKeyDescriptor().visitJdbcValues(key, Clause.WHERE, (value, type) -> {
            assert (paramItr.hasNext());
            JdbcParameter parameter = (JdbcParameter)paramItr.next();
            jdbcParameterBindings.addBinding(parameter, new JdbcParameterBindingImpl(type, value));
        }, session);
        assert (!paramItr.hasNext());
        jdbcServices.getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public CollectionKey getCollectionKey() {
                return collectionKey;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return null;
            }
        }, RowTransformerPassThruImpl.instance(), true);
        return session.getPersistenceContext().getCollection(collectionKey);
    }
}

