/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.RowTransformerDatabaseSnapshotImpl;
import org.jboss.logging.Logger;

class DatabaseSnapshotExecutor {
    private static final Logger log = Logger.getLogger(DatabaseSnapshotExecutor.class);
    private final EntityMappingType entityDescriptor;
    private final SessionFactoryImplementor sessionFactory;
    private final JdbcSelect jdbcSelect;
    private final List<JdbcParameter> jdbcParameters;

    DatabaseSnapshotExecutor(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.sessionFactory = sessionFactory;
        QuerySpec rootQuerySpec = new QuerySpec(true);
        SqlAliasBaseManager sqlAliasBaseManager = new SqlAliasBaseManager();
        LoaderSqlAstCreationState state = new LoaderSqlAstCreationState(rootQuerySpec, sqlAliasBaseManager, LockOptions.READ, sessionFactory);
        NavigablePath rootPath = new NavigablePath(entityDescriptor.getEntityName());
        TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, null, true, LockMode.NONE, sqlAliasBaseManager, state.getSqlExpressionResolver(), () -> rootQuerySpec::applyPredicate, sessionFactory);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        this.jdbcParameters = new ArrayList<JdbcParameter>(entityDescriptor.getIdentifierMapping().getJdbcTypeCount(sessionFactory.getTypeConfiguration()));
        ArrayList<DomainResult> domainResults = new ArrayList<DomainResult>();
        entityDescriptor.getIdentifierMapping().visitColumns((tab, col, isColFormula, jdbcMapping) -> {
            TableReference tableReference = rootTableGroup.resolveTableReference(tab);
            JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcMapping);
            this.jdbcParameters.add(jdbcParameter);
            ColumnReference columnReference = (ColumnReference)state.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, col), s -> new ColumnReference(tableReference, col, isColFormula, jdbcMapping, sessionFactory));
            rootQuerySpec.applyPredicate(new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, jdbcParameter));
            SqlSelection sqlSelection = state.getSqlExpressionResolver().resolveSqlSelection(columnReference, jdbcMapping.getJavaTypeDescriptor(), sessionFactory.getTypeConfiguration());
            domainResults.add(new BasicResult(sqlSelection.getValuesArrayPosition(), null, jdbcMapping.getJavaTypeDescriptor()));
        });
        entityDescriptor.visitStateArrayContributors(contributorMapping -> {
            rootPath.append(contributorMapping.getAttributeName());
            contributorMapping.visitColumns((containingTableExpression, columnExpression, isColumnExpressionFormula, jdbcMapping) -> {
                TableReference tableReference = rootTableGroup.resolveTableReference(containingTableExpression);
                ColumnReference columnReference = (ColumnReference)state.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, columnExpression), s -> new ColumnReference(tableReference, columnExpression, isColumnExpressionFormula, jdbcMapping, sessionFactory));
                SqlSelection sqlSelection = state.getSqlExpressionResolver().resolveSqlSelection(columnReference, jdbcMapping.getJavaTypeDescriptor(), sessionFactory.getTypeConfiguration());
                domainResults.add(new BasicResult(sqlSelection.getValuesArrayPosition(), null, jdbcMapping.getJavaTypeDescriptor()));
            });
        });
        SelectStatement selectStatement = new SelectStatement(rootQuerySpec, domainResults);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        this.jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory).translate(selectStatement);
    }

    Object[] loadDatabaseSnapshot(Object id, final SharedSessionContractImplementor session) {
        if (log.isTraceEnabled()) {
            log.tracef("Getting current persistent state for `%s#%s`", (Object)this.entityDescriptor.getEntityName(), id);
        }
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.entityDescriptor.getIdentifierMapping().getJdbcTypeCount(this.sessionFactory.getTypeConfiguration()));
        Iterator<JdbcParameter> paramItr = this.jdbcParameters.iterator();
        this.entityDescriptor.getIdentifierMapping().visitJdbcValues(id, Clause.WHERE, (value, type) -> {
            assert (paramItr.hasNext());
            JdbcParameter parameter = (JdbcParameter)paramItr.next();
            jdbcParameterBindings.addBinding(parameter, new JdbcParameterBindingImpl(type, value));
        }, session);
        assert (!paramItr.hasNext());
        List list = JdbcSelectExecutorStandardImpl.INSTANCE.list(this.jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return null;
            }
        }, RowTransformerDatabaseSnapshotImpl.instance(), true);
        if (list.isEmpty()) {
            return null;
        }
        int size = list.size();
        assert (size <= 1);
        if (size == 0) {
            return null;
        }
        return (Object[])list.get(0);
    }
}

