/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.spi.SingleIdEntityLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.named.NamedQueryRepository;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;

public class SingleIdEntityLoaderProvidedQueryImpl<T>
implements SingleIdEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    private final NamedQueryMemento namedQueryMemento;

    public SingleIdEntityLoaderProvidedQueryImpl(EntityMappingType entityDescriptor, String loadQueryName, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.namedQueryMemento = SingleIdEntityLoaderProvidedQueryImpl.resolveNamedQuery(loadQueryName, sessionFactory);
        if (this.namedQueryMemento == null) {
            throw new IllegalArgumentException("Could not resolve named load-query [" + entityDescriptor.getEntityName() + "] : " + loadQueryName);
        }
    }

    private static NamedQueryMemento resolveNamedQuery(String queryName, SessionFactoryImplementor sf) {
        NamedQueryRepository namedQueryRepository = sf.getQueryEngine().getNamedQueryRepository();
        NamedNativeQueryMemento nativeQueryMemento = namedQueryRepository.getNativeQueryMemento(queryName);
        if (nativeQueryMemento != null) {
            return nativeQueryMemento;
        }
        return namedQueryRepository.getHqlQueryMemento(queryName);
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    @Override
    public T load(Object pkValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        QueryImplementor query = this.namedQueryMemento.toQuery(session, this.entityDescriptor.getMappedJavaTypeDescriptor().getJavaType());
        query.setParameter(0, pkValue);
        return (T)query.uniqueResult();
    }

    @Override
    public T load(Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        if (entityInstance != null) {
            throw new UnsupportedOperationException();
        }
        return this.load(pkValue, lockOptions, readOnly, session);
    }

    @Override
    public Object[] loadDatabaseSnapshot(Object id, SharedSessionContractImplementor session) {
        return new Object[0];
    }
}

