/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.SingleUniqueKeyEntityLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryOptionsAdapter;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelect;

public class SingleUniqueKeyEntityLoaderStandard<T>
implements SingleUniqueKeyEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    private final ModelPart uniqueKeyAttribute;

    public SingleUniqueKeyEntityLoaderStandard(EntityMappingType entityDescriptor, SingularAttributeMapping uniqueKeyAttribute) {
        this.entityDescriptor = entityDescriptor;
        this.uniqueKeyAttribute = uniqueKeyAttribute instanceof ToOneAttributeMapping ? ((ToOneAttributeMapping)uniqueKeyAttribute).getForeignKeyDescriptor() : uniqueKeyAttribute;
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    @Override
    public T load(Object ukValue, LockOptions lockOptions, final Boolean readOnly, final SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        ArrayList jdbcParameters = new ArrayList();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.entityDescriptor, Collections.emptyList(), this.uniqueKeyAttribute, null, 1, LoadQueryInfluencers.NONE, LockOptions.READ, jdbcParameters::add, sessionFactory);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory).translate(sqlAst);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        Iterator jdbcParamItr = jdbcParameters.iterator();
        this.uniqueKeyAttribute.visitJdbcValues(ukValue, Clause.WHERE, (jdbcValue, jdbcMapping) -> {
            assert (jdbcParamItr.hasNext());
            JdbcParameter jdbcParameter = (JdbcParameter)jdbcParamItr.next();
            jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, jdbcValue));
        }, session);
        List<Object> list = sessionFactory.getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return new QueryOptionsAdapter(){

                    @Override
                    public Boolean isReadOnly() {
                        return readOnly;
                    }
                };
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return afterLoadAction -> {};
            }
        }, row -> row[0], true);
        int size = list.size();
        assert (size <= 1);
        if (size == 0) {
            return null;
        }
        return (T)list.get(0);
    }

    @Override
    public Object resolveId(Object ukValue, final SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        ArrayList jdbcParameters = new ArrayList();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.entityDescriptor, Collections.singletonList(this.entityDescriptor.getIdentifierMapping()), this.uniqueKeyAttribute, null, 1, LoadQueryInfluencers.NONE, LockOptions.READ, jdbcParameters::add, sessionFactory);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory).translate(sqlAst);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        Iterator jdbcParamItr = jdbcParameters.iterator();
        this.uniqueKeyAttribute.visitJdbcValues(ukValue, Clause.WHERE, (jdbcValue, jdbcMapping) -> {
            assert (jdbcParamItr.hasNext());
            JdbcParameter jdbcParameter = (JdbcParameter)jdbcParamItr.next();
            jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, jdbcValue));
        }, session);
        List<Object> list = sessionFactory.getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return afterLoadAction -> {};
            }
        }, row -> row[0], true);
        assert (list.size() == 1);
        return list.get(0);
    }
}

