/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Map;
import java.util.Objects;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.MappingHelper;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;

public class Any
extends SimpleValue {
    private String identifierTypeName;
    private String metaTypeName = "string";
    private Map<Object, String> metaValueToEntityNameMap;
    private boolean lazy = true;

    public Any(MetadataBuildingContext buildingContext, Table table) {
        super(buildingContext, table);
    }

    public String getIdentifierType() {
        return this.identifierTypeName;
    }

    public void setIdentifierType(String identifierType) {
        this.identifierTypeName = identifierType;
    }

    @Override
    public Type getType() throws MappingException {
        BasicType metaType = this.getMetadata().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(this.metaTypeName);
        BasicType identifierType = this.getMetadata().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(this.identifierTypeName);
        return MappingHelper.anyMapping(metaType, identifierType, this.metaValueToEntityNameMap, this.isLazy(), this.getBuildingContext());
    }

    public void setTypeByReflection(String propertyClass, String propertyName) {
    }

    public String getMetaType() {
        return this.metaTypeName;
    }

    public void setMetaType(String type) {
        this.metaTypeName = type;
    }

    public Map getMetaValues() {
        return this.metaValueToEntityNameMap;
    }

    public void setMetaValues(Map metaValueToEntityNameMap) {
        this.metaValueToEntityNameMap = metaValueToEntityNameMap;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean isSame(SimpleValue other) {
        return other instanceof Any && this.isSame((Any)other);
    }

    public boolean isSame(Any other) {
        return super.isSame(other) && Objects.equals(this.identifierTypeName, other.identifierTypeName) && Objects.equals(this.metaTypeName, other.metaTypeName) && Objects.equals(this.metaValueToEntityNameMap, other.metaValueToEntityNameMap) && this.lazy == other.lazy;
    }
}

