/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableResultImpl;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class EmbeddableMappingType
implements ManagedMappingType {
    private final JavaTypeDescriptor embeddableJtd;
    private final EmbeddableRepresentationStrategy representationStrategy;
    private final SessionFactoryImplementor sessionFactory;
    private final Map<String, AttributeMapping> attributeMappings = new LinkedHashMap<String, AttributeMapping>();
    private final EmbeddableValuedModelPart valueMapping;
    private NavigableRole embeddedRole;
    private final boolean createEmptyCompositesEnabled;
    private int cachedJdbcTypeCount = -1;
    private List<JdbcMapping> cachedJdbcMappings;

    public static EmbeddableMappingType from(Component bootDescriptor, CompositeType compositeType, Function<EmbeddableMappingType, EmbeddableValuedModelPart> embeddedPartBuilder, MappingModelCreationProcess creationProcess) {
        RuntimeModelCreationContext creationContext = creationProcess.getCreationContext();
        EmbeddableRepresentationStrategy representationStrategy = creationContext.getBootstrapContext().getRepresentationStrategySelector().resolveStrategy(bootDescriptor, creationContext);
        EmbeddableMappingType mappingType = new EmbeddableMappingType(bootDescriptor, representationStrategy, embeddedPartBuilder, creationContext.getSessionFactory());
        creationProcess.registerInitializationCallback(() -> mappingType.finishInitialization(bootDescriptor, compositeType, creationProcess));
        return mappingType;
    }

    public static EmbeddableMappingType from(Component bootDescriptor, CompositeType compositeType, NavigableRole embeddedRole, Function<EmbeddableMappingType, EmbeddableValuedModelPart> embeddedPartBuilder, MappingModelCreationProcess creationProcess) {
        RuntimeModelCreationContext creationContext = creationProcess.getCreationContext();
        EmbeddableRepresentationStrategy representationStrategy = creationContext.getBootstrapContext().getRepresentationStrategySelector().resolveStrategy(bootDescriptor, creationContext);
        EmbeddableMappingType mappingType = new EmbeddableMappingType(bootDescriptor, representationStrategy, embeddedPartBuilder, creationContext.getSessionFactory());
        creationProcess.registerInitializationCallback(() -> mappingType.finishInitialization(bootDescriptor, compositeType, creationProcess));
        return mappingType;
    }

    private EmbeddableMappingType(Component bootDescriptor, EmbeddableRepresentationStrategy representationStrategy, Function<EmbeddableMappingType, EmbeddableValuedModelPart> embeddedPartBuilder, SessionFactoryImplementor sessionFactory) {
        this.embeddableJtd = representationStrategy.getMappedJavaTypeDescriptor();
        this.representationStrategy = representationStrategy;
        this.sessionFactory = sessionFactory;
        this.valueMapping = embeddedPartBuilder.apply(this);
        ConfigurationService cs = sessionFactory.getServiceRegistry().getService(ConfigurationService.class);
        this.createEmptyCompositesEnabled = ConfigurationHelper.getBoolean("hibernate.create_empty_composites.enabled", cs.getSettings(), false);
    }

    private boolean finishInitialization(Component bootDescriptor, CompositeType compositeType, MappingModelCreationProcess creationProcess) {
        String containingTableExpression = this.valueMapping.getContainingTableExpression();
        List<String> mappedColumnExpressions = this.valueMapping.getMappedColumnExpressions();
        Type[] subtypes = compositeType.getSubtypes();
        int attributeIndex = 0;
        int columnPosition = 0;
        Iterator propertyIterator = bootDescriptor.getPropertyIterator();
        while (propertyIterator.hasNext()) {
            Property bootPropertyDescriptor = (Property)propertyIterator.next();
            Type subtype = subtypes[attributeIndex];
            if (subtype instanceof BasicType) {
                this.attributeMappings.put(bootPropertyDescriptor.getName(), MappingModelCreationHelper.buildBasicAttributeMapping(bootPropertyDescriptor.getName(), this.valueMapping.getNavigableRole().append(bootPropertyDescriptor.getName()), attributeIndex, bootPropertyDescriptor, this, (BasicType)subtype, containingTableExpression, mappedColumnExpressions.get(columnPosition++), false, this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess));
            } else if (subtype instanceof CompositeType) {
                CompositeType subCompositeType = (CompositeType)subtype;
                int columnSpan = subCompositeType.getColumnSpan(creationProcess.getCreationContext().getSessionFactory());
                this.attributeMappings.put(bootPropertyDescriptor.getName(), MappingModelCreationHelper.buildEmbeddedAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, bootPropertyDescriptor, this, subCompositeType, containingTableExpression, ArrayHelper.toStringArray(mappedColumnExpressions.subList(columnPosition, columnPosition + columnSpan)), this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess));
                columnPosition += columnSpan;
            } else {
                EntityPersister entityPersister = creationProcess.getEntityPersister(bootDescriptor.getOwner().getEntityName());
                if (subtype instanceof CollectionType) {
                    this.attributeMappings.put(bootPropertyDescriptor.getName(), MappingModelCreationHelper.buildPluralAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, bootPropertyDescriptor, entityPersister, this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), compositeType.getFetchMode(attributeIndex), creationProcess));
                } else if (subtype instanceof EntityType) {
                    ToOneAttributeMapping toOneAttributeMapping = MappingModelCreationHelper.buildSingularAssociationAttributeMapping(bootPropertyDescriptor.getName(), this.valueMapping.getNavigableRole().append(bootPropertyDescriptor.getName()), attributeIndex, bootPropertyDescriptor, entityPersister, (EntityType)subtype, this.getRepresentationStrategy().resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess);
                    this.attributeMappings.put(bootPropertyDescriptor.getName(), toOneAttributeMapping);
                    ++columnPosition;
                }
            }
            ++attributeIndex;
        }
        return true;
    }

    public EmbeddableValuedModelPart getEmbeddedValueMapping() {
        return this.valueMapping;
    }

    @Override
    public JavaTypeDescriptor getMappedJavaTypeDescriptor() {
        return this.embeddableJtd;
    }

    public EmbeddableRepresentationStrategy getRepresentationStrategy() {
        return this.representationStrategy;
    }

    @Override
    public String getPartName() {
        return this.getEmbeddedValueMapping().getPartName();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.valueMapping.getNavigableRole();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return new EmbeddableResultImpl(navigablePath, this.valueMapping, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public int getNumberOfFetchables() {
        return this.attributeMappings.size();
    }

    @Override
    public void visitFetchables(Consumer<Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        this.visitAttributeMappings(attributeMapping -> fetchableConsumer.accept((Fetchable)attributeMapping));
    }

    @Override
    public int getJdbcTypeCount(TypeConfiguration typeConfiguration) {
        if (this.cachedJdbcTypeCount == -1) {
            int count = 0;
            for (AttributeMapping attributeMapping : this.getAttributeMappings()) {
                count += attributeMapping.getJdbcTypeCount(typeConfiguration);
            }
            this.cachedJdbcTypeCount = count;
        }
        return this.cachedJdbcTypeCount;
    }

    @Override
    public List<JdbcMapping> getJdbcMappings(TypeConfiguration typeConfiguration) {
        if (this.cachedJdbcMappings == null) {
            ArrayList result = new ArrayList();
            this.visitJdbcTypes(result::add, Clause.IRRELEVANT, typeConfiguration);
            this.cachedJdbcMappings = Collections.unmodifiableList(result);
        }
        return this.cachedJdbcMappings;
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, Clause clause, TypeConfiguration typeConfiguration) {
        this.attributeMappings.forEach((s, attributeMapping) -> {
            if (attributeMapping instanceof PluralAttributeMapping) {
                return;
            }
            if (attributeMapping instanceof ToOneAttributeMapping) {
                ((ToOneAttributeMapping)attributeMapping).getKeyTargetMatchPart().visitJdbcTypes(action, clause, typeConfiguration);
            } else {
                attributeMapping.visitJdbcTypes(action, clause, typeConfiguration);
            }
        });
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        Collection<AttributeMapping> attributeMappings = this.getAttributeMappings();
        Object[] result = new Object[attributeMappings.size()];
        int i = 0;
        for (AttributeMapping mapping : attributeMappings) {
            Object o = mapping.getPropertyAccess().getGetter().get(value);
            result[i] = mapping.disassemble(o, session);
            ++i;
        }
        return result;
    }

    @Override
    public void visitJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer consumer, SharedSessionContractImplementor session) {
        this.attributeMappings.forEach((s, attributeMapping) -> {
            Object o = attributeMapping.getPropertyAccess().getGetter().get(value);
            attributeMapping.visitJdbcValues(o, clause, consumer, session);
        });
    }

    @Override
    public void visitDisassembledJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        Collection<AttributeMapping> attributeMappings = this.getAttributeMappings();
        Iterator<AttributeMapping> iterator = attributeMappings.iterator();
        Object[] values = (Object[])value;
        int i = 0;
        while (iterator.hasNext()) {
            AttributeMapping mapping = iterator.next();
            mapping.visitDisassembledJdbcValues(values[i], clause, valuesConsumer, session);
            ++i;
        }
    }

    @Override
    public void visitColumns(ColumnConsumer consumer) {
        this.attributeMappings.values().forEach(attributeMapping -> attributeMapping.visitColumns(consumer));
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.valueMapping.findContainingEntityMapping();
    }

    @Override
    public int getNumberOfAttributeMappings() {
        return this.attributeMappings.size();
    }

    @Override
    public AttributeMapping findAttributeMapping(String name) {
        return this.attributeMappings.get(name);
    }

    @Override
    public Collection<AttributeMapping> getAttributeMappings() {
        return this.attributeMappings.values();
    }

    @Override
    public void visitAttributeMappings(Consumer<AttributeMapping> action) {
        this.attributeMappings.values().forEach(action);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.attributeMappings.get(name);
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.visitAttributeMappings(consumer::accept);
    }

    public void setPropertyValues(final Object compositeInstance, final Object[] resolvedValues) {
        this.visitAttributeMappings(new Consumer<AttributeMapping>(){
            private int i = 0;

            @Override
            public void accept(AttributeMapping attributeMapping) {
                attributeMapping.getAttributeMetadataAccess().resolveAttributeMetadata(null).getPropertyAccess().getSetter().set(compositeInstance, resolvedValues[this.i++], EmbeddableMappingType.this.sessionFactory);
            }
        });
    }

    public boolean isCreateEmptyCompositesEnabled() {
        return this.createEmptyCompositesEnabled;
    }
}

