/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.ConvertibleModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.EntityIdentifierNavigablePath;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class BasicValuedCollectionPart
implements CollectionPart,
BasicValuedModelPart,
ConvertibleModelPart,
FetchOptions {
    private final NavigableRole navigableRole;
    private final CollectionPersister collectionDescriptor;
    private final CollectionPart.Nature nature;
    private final JdbcMapping mapper;
    private final BasicValueConverter valueConverter;
    private final String tableExpression;
    private final String columnExpression;

    public BasicValuedCollectionPart(CollectionPersister collectionDescriptor, CollectionPart.Nature nature, JdbcMapping mapper, BasicValueConverter valueConverter, String tableExpression, String columnExpression) {
        this.navigableRole = collectionDescriptor.getNavigableRole().append(nature.getName());
        this.collectionDescriptor = collectionDescriptor;
        this.nature = nature;
        this.mapper = mapper;
        this.valueConverter = valueConverter;
        this.tableExpression = tableExpression;
        this.columnExpression = columnExpression;
    }

    @Override
    public CollectionPart.Nature getNature() {
        return this.nature;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.mapper::getJavaTypeDescriptor;
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public String getMappedColumnExpression() {
        return this.columnExpression;
    }

    @Override
    public BasicValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.mapper.getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.getJavaTypeDescriptor(), this.valueConverter, navigablePath);
    }

    private SqlSelection resolveSqlSelection(TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlExpressionResolver exprResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        return exprResolver.resolveSqlSelection(exprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableGroup.getPrimaryTableReference(), this.columnExpression), sqlAstProcessingState -> new ColumnReference(tableGroup.getPrimaryTableReference().getIdentificationVariable(), this.columnExpression, false, this.mapper, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), this.getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.collectionDescriptor.getAttributeMapping().findContainingEntityMapping();
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.mapper;
    }

    @Override
    public MappingType getMappedTypeDescriptor() {
        return this::getJavaTypeDescriptor;
    }

    @Override
    public String getFetchableName() {
        return this.nature == CollectionPart.Nature.ELEMENT ? "{value}" : "{key}";
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        ResultsLogger.LOGGER.debugf("Generating Fetch for collection-part : `%s` -> `%s`", this.collectionDescriptor.getRole(), this.nature.getName());
        NavigablePath parentNavigablePath = fetchablePath.getParent();
        if (parentNavigablePath instanceof EntityIdentifierNavigablePath) {
            parentNavigablePath = parentNavigablePath.getParent();
        }
        TableGroup tableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(parentNavigablePath);
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, creationState);
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, false, this.valueConverter, FetchTiming.IMMEDIATE, creationState);
    }

    @Override
    public int getJdbcTypeCount(TypeConfiguration typeConfiguration) {
        return 1;
    }

    @Override
    public List<JdbcMapping> getJdbcMappings(TypeConfiguration typeConfiguration) {
        return Collections.singletonList(this.getJdbcMapping());
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, Clause clause, TypeConfiguration typeConfiguration) {
        action.accept(this.getJdbcMapping());
    }

    @Override
    public void visitColumns(ColumnConsumer consumer) {
        consumer.accept(this.tableExpression, this.columnExpression, false, this.getJdbcMapping());
    }

    @Override
    public void visitDisassembledJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(value, this.getJdbcMapping());
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        if (this.valueConverter != null) {
            return this.valueConverter.toRelationalValue(value);
        }
        return value;
    }
}

