/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.ConvertibleModelPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class BasicValuedSingularAttributeMapping
extends AbstractSingularAttributeMapping
implements SingularAttributeMapping,
BasicValuedModelPart,
ConvertibleModelPart {
    private final NavigableRole navigableRole;
    private final String tableExpression;
    private final String mappedColumnExpression;
    private final boolean isMappedColumnExpressionFormula;
    private final JdbcMapping jdbcMapping;
    private final BasicValueConverter valueConverter;
    private final JavaTypeDescriptor domainTypeDescriptor;

    public BasicValuedSingularAttributeMapping(String attributeName, NavigableRole navigableRole, int stateArrayPosition, StateArrayContributorMetadataAccess attributeMetadataAccess, FetchStrategy mappedFetchStrategy, String tableExpression, String mappedColumnExpression, boolean isMappedColumnExpressionFormula, BasicValueConverter valueConverter, JdbcMapping jdbcMapping, ManagedMappingType declaringType, PropertyAccess propertyAccess) {
        super(attributeName, stateArrayPosition, attributeMetadataAccess, mappedFetchStrategy, declaringType, propertyAccess);
        this.navigableRole = navigableRole;
        this.tableExpression = tableExpression;
        this.mappedColumnExpression = mappedColumnExpression;
        this.isMappedColumnExpressionFormula = isMappedColumnExpressionFormula;
        this.valueConverter = valueConverter;
        this.jdbcMapping = jdbcMapping;
        this.domainTypeDescriptor = valueConverter == null ? jdbcMapping.getJavaTypeDescriptor() : valueConverter.getDomainJavaDescriptor();
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public MappingType getMappedTypeDescriptor() {
        return this.getJdbcMapping();
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.domainTypeDescriptor;
    }

    @Override
    public String getMappedColumnExpression() {
        return this.mappedColumnExpression;
    }

    @Override
    public boolean isMappedColumnExpressionFormula() {
        return this.isMappedColumnExpressionFormula;
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public BasicValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.getMappedTypeDescriptor().getMappedJavaTypeDescriptor(), this.valueConverter, navigablePath);
    }

    private SqlSelection resolveSqlSelection(TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(this.getContainingTableExpression());
        String tableAlias = tableReference.getIdentificationVariable();
        String columnExpression = this.getMappedColumnExpression();
        return expressionResolver.resolveSqlSelection(expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, columnExpression), sqlAstProcessingState -> new ColumnReference(tableAlias, columnExpression, this.isMappedColumnExpressionFormula(), this.jdbcMapping, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), this.valueConverter == null ? this.getMappedTypeDescriptor().getMappedJavaTypeDescriptor() : this.valueConverter.getRelationalJavaDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(this.getContainingTableExpression());
        expressionResolver.resolveSqlSelection(expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, this.getMappedColumnExpression()), sqlAstProcessingState -> new ColumnReference(tableReference.getIdentificationVariable(), this.getMappedColumnExpression(), this.isMappedColumnExpressionFormula(), this.jdbcMapping, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), this.valueConverter == null ? this.getMappedTypeDescriptor().getMappedJavaTypeDescriptor() : this.valueConverter.getRelationalJavaDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        assert (tableGroup != null);
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, creationState);
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, this.getAttributeMetadataAccess().resolveAttributeMetadata(null).isNullable(), this.getValueConverter(), fetchTiming, creationState);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        if (this.valueConverter != null) {
            return this.valueConverter.toRelationalValue(value);
        }
        return value;
    }

    @Override
    public void visitDisassembledJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(value, this.getJdbcMapping());
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, Clause clause, TypeConfiguration typeConfiguration) {
        action.accept(this.getJdbcMapping());
    }

    @Override
    public void visitColumns(ColumnConsumer consumer) {
        consumer.accept(this.tableExpression, this.mappedColumnExpression, this.isMappedColumnExpressionFormula, this.jdbcMapping);
    }
}

