/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.property.access.internal.PropertyAccessStrategyBasicImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.CompositeTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableFetchImpl;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableResultImpl;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class EmbeddedCollectionPart
implements CollectionPart,
EmbeddableValuedFetchable,
FetchOptions {
    private final NavigableRole navigableRole;
    private final CollectionPersister collectionDescriptor;
    private final CollectionPart.Nature nature;
    private final EmbeddableMappingType embeddableMappingType;
    private final String containingTableExpression;
    private final PropertyAccess parentInjectionAttributeProperyAccess;
    private final List<String> columnExpressions;
    private final String sqlAliasStem;

    public EmbeddedCollectionPart(CollectionPersister collectionDescriptor, CollectionPart.Nature nature, EmbeddableMappingType embeddableMappingType, String parentInjectionAttributeName, String containingTableExpression, List<String> columnExpressions, String sqlAliasStem) {
        this.navigableRole = collectionDescriptor.getNavigableRole().appendContainer(nature.getName());
        this.collectionDescriptor = collectionDescriptor;
        this.nature = nature;
        this.parentInjectionAttributeProperyAccess = parentInjectionAttributeName != null ? PropertyAccessStrategyBasicImpl.INSTANCE.buildPropertyAccess(embeddableMappingType.getMappedJavaTypeDescriptor().getJavaType(), parentInjectionAttributeName) : null;
        this.embeddableMappingType = embeddableMappingType;
        this.containingTableExpression = containingTableExpression;
        this.columnExpressions = columnExpressions;
        this.sqlAliasStem = sqlAliasStem;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return new EmbeddableResultImpl(navigablePath, this, resultVariable, creationState);
    }

    @Override
    public CollectionPart.Nature getNature() {
        return this.nature;
    }

    @Override
    public EmbeddableMappingType getEmbeddableTypeDescriptor() {
        return this.embeddableMappingType;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.getEmbeddableTypeDescriptor();
    }

    @Override
    public String getContainingTableExpression() {
        return this.containingTableExpression;
    }

    @Override
    public List<String> getMappedColumnExpressions() {
        return this.columnExpressions;
    }

    @Override
    public PropertyAccess getParentInjectionAttributePropertyAccess() {
        return this.parentInjectionAttributeProperyAccess;
    }

    @Override
    public String getFetchableName() {
        return this.getNature().getName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public int getJdbcTypeCount(TypeConfiguration typeConfiguration) {
        return this.getEmbeddableTypeDescriptor().getJdbcTypeCount(typeConfiguration);
    }

    @Override
    public List<JdbcMapping> getJdbcMappings(TypeConfiguration typeConfiguration) {
        return this.getEmbeddableTypeDescriptor().getJdbcMappings(typeConfiguration);
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, Clause clause, TypeConfiguration typeConfiguration) {
        this.getEmbeddableTypeDescriptor().visitJdbcTypes(action, clause, typeConfiguration);
    }

    @Override
    public void visitJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        this.getEmbeddableTypeDescriptor().visitJdbcValues(value, clause, valuesConsumer, session);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        return new EmbeddableFetchImpl(fetchablePath, this, fetchParent, FetchTiming.IMMEDIATE, selected, true, creationState);
    }

    @Override
    public Expression toSqlExpression(TableGroup tableGroup, Clause clause, SqmToSqlAstConverter walker, SqlAstCreationState sqlAstCreationState) {
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        ArrayList expressions = new ArrayList();
        this.getEmbeddableTypeDescriptor().visitColumns((tableExpression, columnExpression, isColumnExpressionFormula, jdbcMapping) -> {
            assert (this.containingTableExpression.equals(tableExpression));
            assert (this.columnExpressions.contains(columnExpression));
            expressions.add(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableExpression, columnExpression), sqlAstProcessingState -> new ColumnReference(tableGroup.resolveTableReference(tableExpression), columnExpression, isColumnExpressionFormula, jdbcMapping, sqlAstCreationState.getCreationContext().getSessionFactory())));
        });
        return new SqlTuple(expressions, this);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        assert (lhs.getModelPart() instanceof PluralAttributeMapping);
        CompositeTableGroup tableGroup = new CompositeTableGroup(navigablePath, this, lhs);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(navigablePath, sqlAstJoinType, tableGroup, null);
        lhs.addTableGroupJoin(tableGroupJoin);
        return tableGroupJoin;
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.getEmbeddableTypeDescriptor().findSubPart(name, treatTargetType);
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.getEmbeddableTypeDescriptor().visitSubParts(consumer, treatTargetType);
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getEmbeddableTypeDescriptor().getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.collectionDescriptor.getAttributeMapping().findContainingEntityMapping();
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getEmbeddableTypeDescriptor().getNumberOfAttributeMappings();
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public void visitColumns(ColumnConsumer consumer) {
        this.getEmbeddableTypeDescriptor().visitColumns(consumer);
    }
}

