/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.internal.AbstractCompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;

public class EmbeddedIdentifierMappingImpl
extends AbstractCompositeIdentifierMapping
implements SingleAttributeIdentifierMapping {
    private final String name;
    private final PropertyAccess propertyAccess;

    public EmbeddedIdentifierMappingImpl(EntityMappingType entityMapping, String name, EmbeddableMappingType embeddableDescriptor, StateArrayContributorMetadataAccess attributeMetadataAccess, PropertyAccess propertyAccess, String tableExpression, String[] attrColumnNames, SessionFactoryImplementor sessionFactory) {
        super(attributeMetadataAccess, embeddableDescriptor, entityMapping, tableExpression, attrColumnNames, sessionFactory);
        this.name = name;
        this.propertyAccess = propertyAccess;
    }

    @Override
    public String getPartName() {
        return this.name;
    }

    @Override
    public Object getIdentifier(Object entity, SharedSessionContractImplementor session) {
        if (entity instanceof HibernateProxy) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
        }
        return this.propertyAccess.getGetter().get(entity);
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        this.propertyAccess.getSetter().set(entity, id, session.getFactory());
    }

    @Override
    public void visitJdbcValues(Object value, Clause clause, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        this.getEmbeddableTypeDescriptor().getAttributeMappings().forEach(attributeMapping -> {
            Object o = attributeMapping.getPropertyAccess().getGetter().get(value);
            if (attributeMapping instanceof ToOneAttributeMapping) {
                EntityMappingType associatedEntityMappingType = ((ToOneAttributeMapping)attributeMapping).getAssociatedEntityMappingType();
                EntityIdentifierMapping identifierMapping = associatedEntityMappingType.getIdentifierMapping();
                Object identifier = identifierMapping.getIdentifier(o, session);
                identifierMapping.visitJdbcValues(identifier, clause, valuesConsumer, session);
            } else {
                attributeMapping.visitJdbcValues(o, clause, valuesConsumer, session);
            }
        });
    }

    @Override
    public Expression toSqlExpression(TableGroup tableGroup, Clause clause, SqmToSqlAstConverter walker, final SqlAstCreationState sqlAstCreationState) {
        final List<String> attrColumnNames = this.getMappedColumnExpressions();
        final ArrayList columnReferences = CollectionHelper.arrayList(attrColumnNames.size());
        final TableReference tableReference = tableGroup.resolveTableReference(this.getContainingTableExpression());
        this.getEmbeddableTypeDescriptor().visitJdbcTypes(new Consumer<JdbcMapping>(){
            private int index = 0;

            @Override
            public void accept(JdbcMapping jdbcMapping) {
                String attrColumnExpr = (String)attrColumnNames.get(this.index++);
                Expression columnReference = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, attrColumnExpr), sqlAstProcessingState -> new ColumnReference(tableReference.getIdentificationVariable(), attrColumnExpr, false, jdbcMapping, sqlAstCreationState.getCreationContext().getSessionFactory()));
                columnReferences.add((ColumnReference)columnReference);
            }
        }, clause, sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration());
        return new SqlTuple(columnReferences, this);
    }

    @Override
    public String getSqlAliasStem() {
        return this.name;
    }

    @Override
    public String getFetchableName() {
        return this.name;
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getEmbeddableTypeDescriptor().getNumberOfAttributeMappings();
    }

    @Override
    public int getAttributeCount() {
        return this.getEmbeddableTypeDescriptor().getNumberOfAttributeMappings();
    }

    @Override
    public Collection<SingularAttributeMapping> getAttributes() {
        return this.getEmbeddableTypeDescriptor().getAttributeMappings();
    }

    @Override
    public PropertyAccess getPropertyAccess() {
        return this.propertyAccess;
    }

    @Override
    public String getAttributeName() {
        return this.name;
    }
}

