/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityRowIdMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class EntityRowIdMappingImpl
implements EntityRowIdMapping {
    private final String rowIdName;
    private final EntityMappingType declaringType;
    private final String tableExpression;

    public EntityRowIdMappingImpl(String rowIdName, String tableExpression, EntityMappingType declaringType) {
        this.rowIdName = rowIdName;
        this.tableExpression = tableExpression;
        this.declaringType = declaringType;
    }

    @Override
    public String getRowIdName() {
        return this.rowIdName;
    }

    @Override
    public MappingType getPartMappingType() {
        return this::getJavaTypeDescriptor;
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return JavaObjectType.INSTANCE.getJavaTypeDescriptor();
    }

    @Override
    public String getPartName() {
        return this.rowIdName;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return null;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.declaringType;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference columnTableReference = tableGroup.resolveTableReference(this.tableExpression);
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(columnTableReference, this.rowIdName), sqlAstProcessingState -> new ColumnReference(columnTableReference, this.rowIdName, false, (JdbcMapping)JavaObjectType.INSTANCE, sqlAstCreationState.getCreationContext().getSessionFactory())), JavaObjectType.INSTANCE.getJdbcMapping().getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.getJavaTypeDescriptor(), navigablePath);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
    }
}

