/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.List;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.AbstractEntityDiscriminatorMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.BasicType;

public class JoinedSubclassDiscriminatorMappingImpl
extends AbstractEntityDiscriminatorMapping {
    private final NavigableRole navigableRole;
    private final CaseSearchedExpression caseSearchedExpression;
    private final List<ColumnReference> columnReferences;

    public JoinedSubclassDiscriminatorMappingImpl(EntityPersister entityDescriptor, String tableExpression, String mappedColumnExpression, CaseSearchedExpression caseSearchedExpression, List<ColumnReference> columnReferences, BasicType mappingType) {
        super(entityDescriptor, tableExpression, mappedColumnExpression, mappingType);
        this.navigableRole = entityDescriptor.getNavigableRole().append("{discriminator}");
        this.caseSearchedExpression = caseSearchedExpression;
        this.columnReferences = columnReferences;
    }

    @Override
    protected SqlSelection resolveSqlSelection(TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        this.columnReferences.forEach(columnReference -> expressionResolver.resolveSqlSelection((Expression)columnReference, this.getMappedTypeDescriptor().getMappedJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration()));
        return expressionResolver.resolveSqlSelection(expressionResolver.resolveSqlExpression(this.getMappedColumnExpression(), sqlAstProcessingState -> this.caseSearchedExpression), this.getMappedTypeDescriptor().getMappedJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.getEntityDescriptor();
    }
}

