/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import org.hibernate.SortOrder;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.mapping.ordering.ast.OrderingExpression;
import org.hibernate.metamodel.mapping.ordering.ast.SequencePart;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SortSpecification;

public class ColumnReference
implements OrderingExpression,
SequencePart {
    private final String columnExpression;
    private final boolean isColumnExpressionFormula;
    private final NavigablePath rootPath;

    public ColumnReference(String columnExpression, boolean isColumnExpressionFormula, NavigablePath rootPath) {
        this.columnExpression = columnExpression;
        this.isColumnExpressionFormula = isColumnExpressionFormula;
        this.rootPath = rootPath;
    }

    public String getColumnExpression() {
        return this.columnExpression;
    }

    public boolean isColumnExpressionFormula() {
        return this.isColumnExpressionFormula;
    }

    @Override
    public SequencePart resolvePathPart(String name, boolean isTerminal, TranslationContext translationContext) {
        throw new UnsupportedOperationException("ColumnReference cannot be de-referenced");
    }

    @Override
    public void apply(QuerySpec ast, TableGroup tableGroup, String collation, SortOrder sortOrder, SqlAstCreationState creationState) {
        TableReference tableReference = this.getTableReference(tableGroup);
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlExpressionResolver();
        ast.addSortSpecification(new SortSpecification(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, this.columnExpression), sqlAstProcessingState -> new org.hibernate.sql.ast.tree.expression.ColumnReference(tableReference, this.columnExpression, this.isColumnExpressionFormula, null, creationState.getCreationContext().getSessionFactory())), collation, sortOrder));
    }

    TableReference getTableReference(TableGroup tableGroup) {
        ModelPartContainer modelPart = tableGroup.getModelPart();
        if (modelPart instanceof PluralAttributeMapping) {
            MappingType partMappingType = ((PluralAttributeMapping)modelPart).getElementDescriptor().getPartMappingType();
            if (partMappingType instanceof AbstractEntityPersister) {
                AbstractEntityPersister abstractEntityPersister = (AbstractEntityPersister)partMappingType;
                int i = abstractEntityPersister.determineTableNumberForColumn(this.columnExpression);
                String tableName = abstractEntityPersister.getTableName(i);
                for (TableReferenceJoin tableReferenceJoin : tableGroup.getTableReferenceJoins()) {
                    TableReference joinedTableReference = tableReferenceJoin.getJoinedTableReference();
                    if (!joinedTableReference.getTableExpression().equals(tableName)) continue;
                    return joinedTableReference;
                }
            } else {
                return tableGroup.getPrimaryTableReference();
            }
        }
        return null;
    }
}

