/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import org.hibernate.SortOrder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.ast.OrderingExpression;
import org.hibernate.metamodel.mapping.ordering.ast.SequencePart;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SortSpecification;

public interface DomainPath
extends OrderingExpression,
SequencePart {
    public NavigablePath getNavigablePath();

    public DomainPath getLhs();

    public ModelPart getReferenceModelPart();

    default public PluralAttributeMapping getPluralAttribute() {
        return this.getLhs().getPluralAttribute();
    }

    @Override
    default public void apply(QuerySpec ast, TableGroup tableGroup, String collation, SortOrder sortOrder, SqlAstCreationState creationState) {
        SqlAstCreationContext creationContext = creationState.getCreationContext();
        SessionFactoryImplementor sessionFactory = creationContext.getSessionFactory();
        SqlExpressionResolver sqlExprResolver = creationState.getSqlExpressionResolver();
        if (this.getReferenceModelPart() instanceof BasicValuedModelPart) {
            BasicValuedModelPart basicValuedPart = (BasicValuedModelPart)this.getReferenceModelPart();
            TableReference tableReference = tableGroup.resolveTableReference(basicValuedPart.getContainingTableExpression());
            ast.addSortSpecification(new SortSpecification(new ColumnReference(tableReference, basicValuedPart.getMappedColumnExpression(), basicValuedPart.isMappedColumnExpressionFormula(), basicValuedPart.getJdbcMapping(), creationState.getCreationContext().getSessionFactory()), collation, sortOrder));
        } else {
            this.getReferenceModelPart().visitColumns((tableExpression, columnExpression, isColumnExpressionFormula, jdbcMapping) -> {
                TableReference tableReference = tableGroup.resolveTableReference(tableExpression);
                ast.addSortSpecification(new SortSpecification(sqlExprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableExpression, columnExpression), sqlAstProcessingState -> new ColumnReference(tableReference, columnExpression, isColumnExpressionFormula, jdbcMapping, sessionFactory)), collation, sortOrder));
            });
        }
    }
}

