/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.hibernate.SortOrder;
import org.hibernate.grammars.ordering.OrderingParser;
import org.hibernate.grammars.ordering.OrderingParserBaseVisitor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPath;
import org.hibernate.metamodel.mapping.ordering.ast.FunctionExpression;
import org.hibernate.metamodel.mapping.ordering.ast.OrderByComplianceViolation;
import org.hibernate.metamodel.mapping.ordering.ast.OrderingExpression;
import org.hibernate.metamodel.mapping.ordering.ast.OrderingSpecification;
import org.hibernate.metamodel.mapping.ordering.ast.PathConsumer;

public class ParseTreeVisitor
extends OrderingParserBaseVisitor<Object> {
    private final PathConsumer pathConsumer;
    private final TranslationContext translationContext;

    public ParseTreeVisitor(PluralAttributeMapping pluralAttributeMapping, TranslationContext translationContext) {
        this.pathConsumer = new PathConsumer(pluralAttributeMapping, translationContext);
        this.translationContext = translationContext;
    }

    @Override
    public List<OrderingSpecification> visitOrderByFragment(OrderingParser.OrderByFragmentContext parsedFragment) {
        List<OrderingParser.SortSpecificationContext> parsedSortSpecifications = parsedFragment.sortSpecification();
        assert (parsedSortSpecifications != null);
        if (parsedSortSpecifications.size() == 1) {
            return Collections.singletonList(this.visitSortSpecification(parsedSortSpecifications.get(0)));
        }
        ArrayList<OrderingSpecification> specifications = new ArrayList<OrderingSpecification>(parsedSortSpecifications.size());
        for (OrderingParser.SortSpecificationContext parsedSortSpecification : parsedSortSpecifications) {
            specifications.add(this.visitSortSpecification(parsedSortSpecification));
        }
        return specifications;
    }

    @Override
    public OrderingSpecification visitSortSpecification(OrderingParser.SortSpecificationContext parsedSpec) {
        assert (parsedSpec != null);
        assert (parsedSpec.expression() != null);
        OrderingExpression orderingExpression = this.visitExpression(parsedSpec.expression());
        if (this.translationContext.getJpaCompliance().isJpaOrderByMappingComplianceEnabled() && !(orderingExpression instanceof DomainPath)) {
            throw new OrderByComplianceViolation("`@OrderBy` expression (" + parsedSpec.expression().getText() + ") resolved to `" + orderingExpression + "` which is not a domain-model reference which violates the JPA specification");
        }
        OrderingSpecification result = new OrderingSpecification(orderingExpression);
        if (parsedSpec.collationSpecification() != null) {
            result.setCollation(parsedSpec.collationSpecification().identifier().getText());
        }
        if (parsedSpec.direction() != null && parsedSpec.direction().DESC() != null) {
            result.setSortOrder(SortOrder.DESCENDING);
        } else {
            result.setSortOrder(SortOrder.ASCENDING);
        }
        return result;
    }

    @Override
    public OrderingExpression visitExpression(OrderingParser.ExpressionContext ctx) {
        if (ctx.function() != null) {
            return this.visitFunction(ctx.function());
        }
        if (ctx.identifier() != null) {
            this.pathConsumer.consumeIdentifier(ctx.identifier().getText(), true, true);
            return (OrderingExpression)((Object)this.pathConsumer.getConsumedPart());
        }
        assert (ctx.dotIdentifier() != null);
        int numberOfParts = ctx.dotIdentifier().IDENTIFIER().size();
        boolean firstPass = true;
        for (int i = 0; i < numberOfParts; ++i) {
            TerminalNode partNode = ctx.dotIdentifier().IDENTIFIER().get(i);
            this.pathConsumer.consumeIdentifier(partNode.getText(), firstPass, true);
            firstPass = false;
        }
        return (OrderingExpression)((Object)this.pathConsumer.getConsumedPart());
    }

    @Override
    public FunctionExpression visitFunction(OrderingParser.FunctionContext ctx) {
        if (ctx.simpleFunction() != null) {
            FunctionExpression function = new FunctionExpression(ctx.simpleFunction().identifier().getText(), ctx.simpleFunction().functionArguments().expression().size());
            for (int i = 0; i < ctx.simpleFunction().functionArguments().expression().size(); ++i) {
                OrderingParser.ExpressionContext arg = ctx.simpleFunction().functionArguments().expression(i);
                function.addArgument(this.visitExpression(arg));
            }
            return function;
        }
        assert (ctx.packagedFunction() != null);
        FunctionExpression function = new FunctionExpression(ctx.packagedFunction().dotIdentifier().getText(), ctx.packagedFunction().functionArguments().expression().size());
        for (int i = 0; i < ctx.packagedFunction().functionArguments().expression().size(); ++i) {
            OrderingParser.ExpressionContext arg = ctx.packagedFunction().functionArguments().expression(i);
            function.addArgument(this.visitExpression(arg));
        }
        return function;
    }

    @Override
    public String visitCollationSpecification(OrderingParser.CollationSpecificationContext ctx) {
        throw new IllegalStateException("Unexpected call to #visitCollationSpecification");
    }
}

