/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.mapping.ordering.ast.RootSequencePart;
import org.hibernate.metamodel.mapping.ordering.ast.SequencePart;
import org.hibernate.query.hql.internal.BasicDotIdentifierConsumer;
import org.jboss.logging.Logger;

public class PathConsumer {
    private static final Logger log = Logger.getLogger(BasicDotIdentifierConsumer.class);
    private final TranslationContext translationContext;
    private final SequencePart rootSequencePart;
    private String pathSoFar;
    private SequencePart currentPart;

    public PathConsumer(PluralAttributeMapping pluralAttributeMapping, TranslationContext translationContext) {
        this.translationContext = translationContext;
        this.rootSequencePart = new RootSequencePart(pluralAttributeMapping);
    }

    public SequencePart getConsumedPart() {
        return this.currentPart;
    }

    public void consumeIdentifier(String identifier, boolean isBase, boolean isTerminal) {
        if (isBase) {
            this.reset();
        }
        this.pathSoFar = this.pathSoFar == null ? identifier : this.pathSoFar + '.' + identifier;
        log.tracef("BasicDotIdentifierHandler#consumeIdentifier( %s, %s, %s ) - %s", new Object[]{identifier, isBase, isTerminal, this.pathSoFar});
        this.currentPart = this.currentPart.resolvePathPart(identifier, isTerminal, this.translationContext);
    }

    private void reset() {
        this.pathSoFar = null;
        this.currentPart = this.rootSequencePart;
    }
}

