/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.mapping.ordering.ast.CollectionPartPath;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPath;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPathContinuation;
import org.hibernate.query.NavigablePath;

public class PluralAttributePath
implements DomainPath {
    private final NavigablePath navigablePath;
    private final PluralAttributeMapping pluralAttributeMapping;

    PluralAttributePath(PluralAttributeMapping pluralAttributeMapping) {
        this.navigablePath = new NavigablePath(pluralAttributeMapping.getRootPathName());
        this.pluralAttributeMapping = pluralAttributeMapping;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public DomainPath getLhs() {
        return null;
    }

    @Override
    public PluralAttributeMapping getReferenceModelPart() {
        return this.pluralAttributeMapping;
    }

    @Override
    public DomainPath resolvePathPart(String name, boolean isTerminal, TranslationContext translationContext) {
        EmbeddableValuedModelPart indexDescriptor;
        ModelPart indexSubPart;
        EmbeddableValuedModelPart elementDescriptor;
        ModelPart elementSubPart;
        ModelPart subPart = this.pluralAttributeMapping.findSubPart(name, null);
        if (subPart != null) {
            if (subPart instanceof CollectionPart) {
                return new CollectionPartPath(this, (CollectionPart)subPart);
            }
            if (!(subPart instanceof EmbeddableValuedModelPart)) {
                CollectionPartPath elementPath = new CollectionPartPath(this, this.pluralAttributeMapping.getElementDescriptor());
                return new DomainPathContinuation(elementPath.getNavigablePath().append(name), this, this.pluralAttributeMapping.getElementDescriptor());
            }
        }
        if (this.pluralAttributeMapping.getElementDescriptor() instanceof EmbeddableValuedModelPart && (elementSubPart = (elementDescriptor = (EmbeddableValuedModelPart)((Object)this.pluralAttributeMapping.getElementDescriptor())).findSubPart(name, null)) != null) {
            CollectionPartPath elementPath = new CollectionPartPath(this, (CollectionPart)((Object)elementDescriptor));
            return new DomainPathContinuation(elementPath.getNavigablePath().append(name), this, elementSubPart);
        }
        if (this.pluralAttributeMapping.getIndexDescriptor() instanceof EmbeddableValuedModelPart && (indexSubPart = (indexDescriptor = (EmbeddableValuedModelPart)((Object)this.pluralAttributeMapping.getIndexDescriptor())).findSubPart(name, null)) != null) {
            CollectionPartPath indexPath = new CollectionPartPath(this, (CollectionPart)((Object)indexDescriptor));
            return new DomainPathContinuation(indexPath.getNavigablePath().append(name), this, indexSubPart);
        }
        return null;
    }
}

