/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.convert.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.EnumValueConverter;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class OrdinalEnumValueConverter<E extends Enum<E>>
implements EnumValueConverter<E, Integer>,
Serializable {
    private final EnumJavaTypeDescriptor<E> enumJavaDescriptor;
    private final SqlTypeDescriptor sqlTypeDescriptor;
    private final JavaTypeDescriptor<Integer> relationalJavaDescriptor;
    private transient ValueExtractor<Integer> valueExtractor;
    private transient ValueBinder<Integer> valueBinder;

    public OrdinalEnumValueConverter(EnumJavaTypeDescriptor<E> enumJavaDescriptor, SqlTypeDescriptor sqlTypeDescriptor, JavaTypeDescriptor<Integer> relationalJavaDescriptor) {
        this.enumJavaDescriptor = enumJavaDescriptor;
        this.sqlTypeDescriptor = sqlTypeDescriptor;
        this.relationalJavaDescriptor = relationalJavaDescriptor;
        this.valueExtractor = sqlTypeDescriptor.getExtractor(relationalJavaDescriptor);
        this.valueBinder = sqlTypeDescriptor.getBinder(relationalJavaDescriptor);
    }

    @Override
    public E toDomainValue(Integer relationalForm) {
        return this.enumJavaDescriptor.fromOrdinal(relationalForm);
    }

    @Override
    public Integer toRelationalValue(E domainForm) {
        return this.enumJavaDescriptor.toOrdinal(domainForm);
    }

    @Override
    public int getJdbcTypeCode() {
        return -6;
    }

    @Override
    public EnumJavaTypeDescriptor<E> getDomainJavaDescriptor() {
        return this.enumJavaDescriptor;
    }

    @Override
    public JavaTypeDescriptor<Integer> getRelationalJavaDescriptor() {
        return this.relationalJavaDescriptor;
    }

    @Override
    public String toSqlLiteral(Object value) {
        return Integer.toString(((Enum)value).ordinal());
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.valueExtractor = this.sqlTypeDescriptor.getExtractor(this.relationalJavaDescriptor);
        this.valueBinder = this.sqlTypeDescriptor.getBinder(this.relationalJavaDescriptor);
    }

    @Override
    public void writeValue(PreparedStatement statement, E value, int position, SharedSessionContractImplementor session) throws SQLException {
        this.valueBinder.bind(statement, this.toRelationalValue(value), position, (WrapperOptions)session);
    }
}

