/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.NamedQueryRepository;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.results.ResultSetMapping;
import org.jboss.logging.Logger;

public class Util {
    private static final Logger log = Logger.getLogger(Util.class);

    private Util() {
    }

    public static void resolveResultSetMappings(String[] resultSetMappingNames, Class[] resultSetMappingClasses, ResultSetMapping resultSetMapping, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        if (!ArrayHelper.isEmpty(resultSetMappingNames)) {
            if (!ArrayHelper.isEmpty(resultSetMappingClasses)) {
                throw new IllegalArgumentException("Cannot specify both result-set mapping names and classes");
            }
            Util.resolveResultSetMappingNames(resultSetMappingNames, resultSetMapping, querySpaceConsumer, context);
        } else if (!ArrayHelper.isEmpty(resultSetMappingClasses)) {
            Util.resolveResultSetMappingClasses(resultSetMappingClasses, resultSetMapping, querySpaceConsumer, context);
        }
    }

    public static void resolveResultSetMappingNames(String[] resultSetMappingNames, ResultSetMapping resultSetMapping, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        NamedQueryRepository namedQueryRepository = context.getSessionFactory().getQueryEngine().getNamedQueryRepository();
        for (String resultSetMappingName : resultSetMappingNames) {
            NamedResultSetMappingMemento memento = namedQueryRepository.getResultSetMappingMemento(resultSetMappingName);
            memento.resolve(resultSetMapping, querySpaceConsumer, context);
        }
    }

    public static void resolveResultSetMappingClasses(Class[] resultSetMappingClasses, ResultSetMapping resultSetMapping, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        throw new NotYetImplementedFor6Exception(Util.class);
    }
}

