/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import org.hibernate.query.NavigablePath;

public class EntityIdentifierNavigablePath
extends NavigablePath {
    private final String identifierAttributeName;

    public EntityIdentifierNavigablePath(NavigablePath parent, String identifierAttributeName) {
        super(parent, "{id}");
        this.identifierAttributeName = identifierAttributeName;
    }

    @Override
    public String getLocalName() {
        return "{id}";
    }

    @Override
    public int hashCode() {
        return this.getParent().getFullPath().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof NavigablePath)) {
            return false;
        }
        NavigablePath otherPath = (NavigablePath)other;
        if (this.getFullPath().equals(((NavigablePath)other).getFullPath())) {
            return true;
        }
        if (this.getParent() == null) {
            if (otherPath.getParent() != null) {
                return false;
            }
            return this.localNamesMatch(otherPath);
        }
        if (otherPath.getParent() == null) {
            return false;
        }
        return this.getParent().equals(otherPath.getParent()) && this.localNamesMatch(otherPath);
    }

    private boolean localNamesMatch(NavigablePath otherPath) {
        String otherLocalName = otherPath.getLocalName();
        return otherLocalName.equals(this.getLocalName()) || otherLocalName.equals(this.identifierAttributeName);
    }
}

