/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import java.util.Locale;
import org.hibernate.query.criteria.LiteralHandlingMode;

public enum QueryLiteralRendering {
    AUTO("auto"),
    AS_LITERAL("literal"),
    AS_PARAM("param"),
    AS_PARAM_OUTSIDE_SELECT("param-outside-select");

    private final String externalForm;

    private QueryLiteralRendering(String externalForm) {
        this.externalForm = externalForm;
    }

    public String toExternalForm() {
        return this.externalForm;
    }

    public static QueryLiteralRendering fromExternalForm(Object externalValue) {
        if (externalValue != null) {
            if (externalValue instanceof QueryLiteralRendering) {
                return (QueryLiteralRendering)((Object)externalValue);
            }
            if (externalValue instanceof LiteralHandlingMode) {
                return ((LiteralHandlingMode)((Object)externalValue)).getCounterpart();
            }
            String externalValueString = externalValue.toString().trim().toLowerCase(Locale.ROOT);
            if (externalValueString.isEmpty()) {
                return null;
            }
            if (QueryLiteralRendering.AS_LITERAL.externalForm.equals(externalValueString)) {
                return AS_LITERAL;
            }
            if (QueryLiteralRendering.AS_PARAM.externalForm.equals(externalValueString)) {
                return AS_PARAM;
            }
            if (QueryLiteralRendering.AS_PARAM_OUTSIDE_SELECT.externalForm.equals(externalValueString)) {
                return AS_PARAM_OUTSIDE_SELECT;
            }
            try {
                LiteralHandlingMode legacy = LiteralHandlingMode.interpret(externalValue);
                return legacy.getCounterpart();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return AS_PARAM_OUTSIDE_SELECT;
    }
}

