/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.function.Consumer;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.internal.FetchBuilderJpa;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.FetchMemento;
import org.hibernate.query.results.FetchBuilder;

public class FetchMementoJpa
implements FetchMemento {
    private final NavigablePath fetchPath;
    private final String attributePath;

    public FetchMementoJpa(NavigablePath fetchPath, String attributePath) {
        this.fetchPath = fetchPath;
        this.attributePath = attributePath;
    }

    @Override
    public FetchBuilder resolve(FetchMemento.Parent parent, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        String[] names = this.attributePath.split("\\.");
        NavigablePath fetchPath = parent.getNavigablePath();
        for (int i = 0; i < names.length; ++i) {
            fetchPath = fetchPath.append(names[i]);
        }
        return new FetchBuilderJpa(fetchPath, this.attributePath);
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.fetchPath;
    }
}

