/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.hql.spi.NamedHqlQueryMemento;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.NamedQueryRepository;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.jboss.logging.Logger;

public class NamedQueryRepositoryImpl
implements NamedQueryRepository {
    private static final Logger log = Logger.getLogger(NamedQueryRepository.class);
    private final Map<String, NamedHqlQueryMemento> hqlMementoMap;
    private final Map<String, NamedNativeQueryMemento> sqlMementoMap;
    private final Map<String, NamedCallableQueryMemento> callableMementoMap;
    private final Map<String, NamedResultSetMappingMemento> resultSetMappingMementoMap;

    public NamedQueryRepositoryImpl(Map<String, NamedHqlQueryMemento> hqlMementoMap, Map<String, NamedNativeQueryMemento> sqlMementoMap, Map<String, NamedCallableQueryMemento> callableMementoMap, Map<String, NamedResultSetMappingMemento> resultSetMappingMementoMap) {
        this.hqlMementoMap = hqlMementoMap;
        this.sqlMementoMap = sqlMementoMap;
        this.callableMementoMap = callableMementoMap;
        this.resultSetMappingMementoMap = resultSetMappingMementoMap;
    }

    @Override
    public NamedHqlQueryMemento getHqlQueryMemento(String queryName) {
        return this.hqlMementoMap.get(queryName);
    }

    @Override
    public void visitHqlQueryMementos(Consumer<NamedHqlQueryMemento> action) {
        this.hqlMementoMap.values().forEach(action);
    }

    @Override
    public synchronized void registerHqlQueryMemento(String name, NamedHqlQueryMemento descriptor) {
        this.hqlMementoMap.put(name, descriptor);
    }

    @Override
    public NamedNativeQueryMemento getNativeQueryMemento(String queryName) {
        return this.sqlMementoMap.get(queryName);
    }

    @Override
    public void visitNativeQueryMementos(Consumer<NamedNativeQueryMemento> action) {
        this.sqlMementoMap.values().forEach(action);
    }

    @Override
    public synchronized void registerNativeQueryMemento(String name, NamedNativeQueryMemento descriptor) {
        this.sqlMementoMap.put(name, descriptor);
    }

    @Override
    public NamedCallableQueryMemento getCallableQueryMemento(String name) {
        return this.callableMementoMap.get(name);
    }

    @Override
    public void visitCallableQueryMementos(Consumer<NamedCallableQueryMemento> action) {
        this.callableMementoMap.values().forEach(action);
    }

    @Override
    public synchronized void registerCallableQueryMemento(String name, NamedCallableQueryMemento memento) {
        this.callableMementoMap.put(name, memento);
    }

    @Override
    public NamedResultSetMappingMemento getResultSetMappingMemento(String mappingName) {
        return this.resultSetMappingMementoMap.get(mappingName);
    }

    @Override
    public void visitResultSetMappingMementos(Consumer<NamedResultSetMappingMemento> action) {
        this.resultSetMappingMementoMap.values().forEach(action);
    }

    @Override
    public void registerResultSetMappingMemento(String name, NamedResultSetMappingMemento memento) {
        this.resultSetMappingMementoMap.put(name, memento);
    }

    @Override
    public void prepare(final SessionFactoryImplementor sessionFactory, MetadataImplementor bootMetamodel, BootstrapContext bootstrapContext) {
        bootMetamodel.visitNamedHqlQueryDefinitions(namedHqlQueryDefinition -> {
            NamedHqlQueryMemento resolved = namedHqlQueryDefinition.resolve(sessionFactory);
            this.hqlMementoMap.put(namedHqlQueryDefinition.getRegistrationName(), resolved);
        });
        bootMetamodel.visitNamedNativeQueryDefinitions(namedNativeQueryDefinition -> {
            NamedNativeQueryMemento resolved = namedNativeQueryDefinition.resolve(sessionFactory);
            this.sqlMementoMap.put(namedNativeQueryDefinition.getRegistrationName(), resolved);
        });
        bootMetamodel.visitNamedProcedureCallDefinition(namedProcedureCallDefinition -> {
            NamedCallableQueryMemento resolved = namedProcedureCallDefinition.resolve(sessionFactory);
            this.callableMementoMap.put(namedProcedureCallDefinition.getRegistrationName(), resolved);
        });
        ResultSetMappingResolutionContext resolutionContext = new ResultSetMappingResolutionContext(){

            @Override
            public SessionFactoryImplementor getSessionFactory() {
                return sessionFactory;
            }
        };
        bootMetamodel.visitNamedResultSetMappingDefinition(namedResultSetMappingDefinition -> {
            NamedResultSetMappingMemento resolved = namedResultSetMappingDefinition.resolve(resolutionContext);
            this.resultSetMappingMementoMap.put(namedResultSetMappingDefinition.getRegistrationName(), resolved);
        });
    }

    @Override
    public Map<String, HibernateException> checkNamedQueries(QueryEngine queryEngine) {
        HashMap<String, HibernateException> errors = new HashMap<String, HibernateException>();
        HqlTranslator sqmProducer = queryEngine.getHqlTranslator();
        QueryInterpretationCache interpretationCache = queryEngine.getInterpretationCache();
        boolean cachingEnabled = interpretationCache.isEnabled();
        log.debugf("Checking %s named HQL queries", this.hqlMementoMap.size());
        for (NamedHqlQueryMemento hqlMemento : this.hqlMementoMap.values()) {
            try {
                log.debugf("Checking named HQL query: %s", (Object)hqlMemento.getRegistrationName());
                hqlMemento.validate(queryEngine);
            }
            catch (HibernateException e) {
                errors.put(hqlMemento.getRegistrationName(), e);
            }
        }
        log.debugf("Checking %s named SQL queries", this.sqlMementoMap.size());
        for (NamedNativeQueryMemento memento : this.sqlMementoMap.values()) {
            memento.validate(queryEngine);
        }
        return errors;
    }

    @Override
    public void close() {
        this.hqlMementoMap.clear();
        this.sqlMementoMap.clear();
        this.callableMementoMap.clear();
        this.resultSetMappingMementoMap.clear();
    }
}

