/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.FetchMemento;
import org.hibernate.query.named.ResultMementoBasic;
import org.hibernate.query.named.ResultMementoEntity;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultBuilderBasicValued;
import org.hibernate.query.results.ResultBuilderEntityValued;
import org.hibernate.query.results.complete.CompleteResultBuilderEntityJpa;
import org.hibernate.query.results.implicit.ImplicitModelPartResultBuilderBasic;

public class ResultMementoEntityJpa
implements ResultMementoEntity,
FetchMemento.Parent {
    private final NavigablePath navigablePath;
    private final EntityMappingType entityDescriptor;
    private final LockMode lockMode;
    private final ResultMementoBasic discriminatorMemento;
    private final Map<String, FetchMemento> explicitFetchMementoMap;

    public ResultMementoEntityJpa(EntityMappingType entityDescriptor, LockMode lockMode, ResultMementoBasic discriminatorMemento, Map<String, FetchMemento> explicitFetchMementoMap) {
        this.navigablePath = new NavigablePath(entityDescriptor.getEntityName());
        this.entityDescriptor = entityDescriptor;
        this.lockMode = lockMode;
        this.discriminatorMemento = discriminatorMemento;
        this.explicitFetchMementoMap = explicitFetchMementoMap;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ResultBuilderEntityValued resolve(Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        ResultBuilder discriminatorResultBuilder;
        EntityDiscriminatorMapping discriminatorMapping = this.entityDescriptor.getDiscriminatorMapping();
        if (discriminatorMapping == null) {
            assert (this.discriminatorMemento == null);
            discriminatorResultBuilder = null;
        } else {
            discriminatorResultBuilder = this.discriminatorMemento != null ? this.discriminatorMemento.resolve((Consumer)querySpaceConsumer, context) : new ImplicitModelPartResultBuilderBasic(this.navigablePath, discriminatorMapping);
        }
        HashMap<String, FetchBuilder> explicitFetchBuilderMap = new HashMap<String, FetchBuilder>();
        this.explicitFetchMementoMap.forEach((relativePath, fetchMemento) -> explicitFetchBuilderMap.put((String)relativePath, fetchMemento.resolve(this, querySpaceConsumer, context)));
        return new CompleteResultBuilderEntityJpa(this.navigablePath, this.entityDescriptor, this.lockMode, (ResultBuilderBasicValued)discriminatorResultBuilder, explicitFetchBuilderMap);
    }
}

