/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.ResultMementoInstantiation;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.complete.CompleteResultBuilderInstantiation;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class ResultMementoInstantiationStandard
implements ResultMementoInstantiation {
    private final JavaTypeDescriptor<?> instantiatedJtd;
    private final List<ResultMementoInstantiation.ArgumentMemento> argumentMementos;

    public ResultMementoInstantiationStandard(JavaTypeDescriptor<?> instantiatedJtd, List<ResultMementoInstantiation.ArgumentMemento> argumentMementos) {
        this.instantiatedJtd = instantiatedJtd;
        this.argumentMementos = argumentMementos;
    }

    @Override
    public ResultBuilder resolve(Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        ArrayList<ResultBuilder> argumentBuilders = CollectionHelper.arrayList(this.argumentMementos.size());
        this.argumentMementos.forEach(argumentMemento -> argumentBuilders.add(argumentMemento.resolve(querySpaceConsumer, context)));
        return new CompleteResultBuilderInstantiation(this.instantiatedJtd, argumentBuilders);
    }
}

