/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.Internal;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.EntityIdentifierNavigablePath;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.Builders;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.FromClauseAccessImpl;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.dynamic.LegacyFetchResolver;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

@Internal
public class DomainResultCreationStateImpl
implements DomainResultCreationState,
SqlAstCreationState,
SqlAstProcessingState,
SqlExpressionResolver {
    private final String stateIdentifier;
    private final FromClauseAccessImpl fromClauseAccess;
    private final JdbcValuesMetadata jdbcResultsMetadata;
    private final Consumer<SqlSelection> sqlSelectionConsumer;
    private final Map<String, SqlSelectionImpl> sqlSelectionMap = new HashMap<String, SqlSelectionImpl>();
    private boolean allowPositionalSelections = true;
    private final SqlAliasBaseManager sqlAliasBaseManager;
    private final LegacyFetchResolverImpl legacyFetchResolver;
    private final SessionFactoryImplementor sessionFactory;
    private final Stack<Function<String, FetchBuilder>> fetchBuilderResolverStack = new StandardStack<Function<String, FetchBuilder>>(fetchableName -> null);
    private final Stack<NavigablePath> relativePathStack = new StandardStack<NavigablePath>();
    private boolean processingKeyFetches = false;

    public DomainResultCreationStateImpl(String stateIdentifier, JdbcValuesMetadata jdbcResultsMetadata, Map<String, Map<String, DynamicFetchBuilderLegacy>> legacyFetchBuilders, Consumer<SqlSelection> sqlSelectionConsumer, SessionFactoryImplementor sessionFactory) {
        this.stateIdentifier = stateIdentifier;
        this.jdbcResultsMetadata = jdbcResultsMetadata;
        this.sqlSelectionConsumer = sqlSelectionConsumer;
        this.fromClauseAccess = new FromClauseAccessImpl();
        this.sqlAliasBaseManager = new SqlAliasBaseManager();
        this.legacyFetchResolver = new LegacyFetchResolverImpl(legacyFetchBuilders);
        this.sessionFactory = sessionFactory;
    }

    public LegacyFetchResolver getLegacyFetchResolver() {
        return this.legacyFetchResolver;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public int getNumberOfProcessedSelections() {
        return this.sqlSelectionMap.size();
    }

    public boolean arePositionalSelectionsAllowed() {
        return this.allowPositionalSelections;
    }

    public void disallowPositionalSelections() {
        ResultsLogger.LOGGER.debugf("Disallowing positional selections : %s", this.stateIdentifier);
        this.allowPositionalSelections = false;
    }

    public JdbcValuesMetadata getJdbcResultsMetadata() {
        return this.jdbcResultsMetadata;
    }

    public void pushExplicitFetchMementoResolver(Function<String, FetchBuilder> resolver) {
        this.fetchBuilderResolverStack.push(resolver);
    }

    public Function<String, FetchBuilder> popExplicitFetchMementoResolver() {
        return this.fetchBuilderResolverStack.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withExplicitFetchMementoResolver(Function<String, FetchBuilder> resolver, Runnable runnable) {
        this.pushExplicitFetchMementoResolver(resolver);
        try {
            runnable.run();
        }
        finally {
            Function<String, FetchBuilder> popped = this.popExplicitFetchMementoResolver();
            assert (popped == resolver);
        }
    }

    @Override
    public FromClauseAccessImpl getFromClauseAccess() {
        return this.fromClauseAccess;
    }

    @Override
    public DomainResultCreationStateImpl getSqlAstCreationState() {
        return this;
    }

    @Override
    public SqlAliasBaseManager getSqlAliasBaseManager() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public boolean forceIdentifierSelection() {
        return false;
    }

    @Override
    public void registerVisitedAssociationKey(AssociationKey associationKey) {
    }

    @Override
    public boolean isAssociationKeyVisited(AssociationKey associationKey) {
        return false;
    }

    @Override
    public ModelPart resolveModelPart(NavigablePath navigablePath) {
        TableGroup parentTableGroup;
        TableGroup tableGroup = this.fromClauseAccess.findTableGroup(navigablePath);
        if (tableGroup != null) {
            return tableGroup.getModelPart();
        }
        if (navigablePath.getParent() != null && (parentTableGroup = this.fromClauseAccess.findTableGroup(navigablePath.getParent())) != null) {
            return parentTableGroup.getModelPart().findSubPart(navigablePath.getLocalName(), null);
        }
        return null;
    }

    @Override
    public DomainResultCreationStateImpl getSqlExpressionResolver() {
        return this.getCurrentProcessingState();
    }

    @Override
    public LockMode determineLockMode(String identificationVariable) {
        return LockMode.READ;
    }

    @Override
    public DomainResultCreationStateImpl getCurrentProcessingState() {
        return this;
    }

    @Override
    public SqlAstCreationContext getCreationContext() {
        return this.getSessionFactory();
    }

    @Override
    public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public SqlAstProcessingState getParentState() {
        return null;
    }

    @Override
    public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
        SqlSelectionImpl existing = this.sqlSelectionMap.get(key);
        if (existing != null) {
            return existing;
        }
        Expression created = creator.apply(this);
        if (created instanceof SqlSelectionImpl) {
            this.sqlSelectionMap.put(key, (SqlSelectionImpl)created);
            this.sqlSelectionConsumer.accept((SqlSelectionImpl)created);
        } else if (created instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)created;
            String columnExpression = columnReference.getColumnExpression();
            int jdbcPosition = this.jdbcResultsMetadata.resolveColumnPosition(columnExpression);
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            SqlSelectionImpl sqlSelection = new SqlSelectionImpl(valuesArrayPosition, columnReference.getJdbcMapping());
            this.sqlSelectionMap.put(key, sqlSelection);
            this.sqlSelectionConsumer.accept(sqlSelection);
            return sqlSelection;
        }
        return created;
    }

    @Override
    public SqlSelection resolveSqlSelection(Expression expression, JavaTypeDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        if (expression == null) {
            throw new IllegalArgumentException("Expression cannot be null");
        }
        assert (expression instanceof SqlSelectionImpl);
        return (SqlSelection)((Object)expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Fetch> visitFetches(FetchParent fetchParent) {
        FetchableContainer fetchableContainer = fetchParent.getReferencedMappingContainer();
        ArrayList<Fetch> fetches = CollectionHelper.arrayList(fetchableContainer.getNumberOfFetchables());
        boolean previous = this.processingKeyFetches;
        this.processingKeyFetches = true;
        if (fetchableContainer instanceof EntityValuedFetchable) {
            EntityValuedFetchable entityValuedFetchable = (EntityValuedFetchable)fetchableContainer;
            EntityIdentifierMapping identifierMapping = entityValuedFetchable.getEntityMappingType().getIdentifierMapping();
            this.relativePathStack.push(new EntityIdentifierNavigablePath(this.relativePathStack.getCurrent(), ResultsHelper.attributeName(identifierMapping)));
            try {
                entityValuedFetchable.getEntityMappingType().visitKeyFetchables(fetchable -> {
                    String fetchableName = fetchable.getFetchableName();
                    NavigablePath fetchPath = fetchParent.getNavigablePath().append(fetchableName);
                    NavigablePath relativePath = this.relativePathStack.isEmpty() ? new NavigablePath(fetchableName) : this.relativePathStack.getCurrent().append(fetchableName);
                }, null);
            }
            finally {
                this.processingKeyFetches = previous;
                this.relativePathStack.pop();
            }
        }
        fetchableContainer.visitFetchables(fetchable -> {
            String fetchableName = fetchable.getFetchableName();
            NavigablePath fetchPath = fetchParent.getNavigablePath().append(fetchableName);
            NavigablePath relativePath = this.relativePathStack.isEmpty() ? new NavigablePath(fetchableName) : this.relativePathStack.getCurrent().append(fetchableName);
            this.relativePathStack.push(relativePath);
            try {
                FetchBuilder explicitFetchBuilder = this.fetchBuilderResolverStack.getCurrent().apply(relativePath.getFullPath());
                FetchBuilder fetchBuilder = explicitFetchBuilder != null ? explicitFetchBuilder : Builders.implicitFetchBuilder(fetchPath, fetchable);
                Fetch fetch = fetchBuilder.buildFetch(fetchParent, fetchPath, this.jdbcResultsMetadata, (s, s2) -> {
                    throw new UnsupportedOperationException();
                }, this);
                fetches.add(fetch);
            }
            finally {
                this.relativePathStack.pop();
            }
        }, null);
        return fetches;
    }

    private static class LegacyFetchResolverImpl
    implements LegacyFetchResolver {
        private final Map<String, Map<String, DynamicFetchBuilderLegacy>> legacyFetchBuilders;

        public LegacyFetchResolverImpl(Map<String, Map<String, DynamicFetchBuilderLegacy>> legacyFetchBuilders) {
            this.legacyFetchBuilders = legacyFetchBuilders;
        }

        @Override
        public DynamicFetchBuilderLegacy resolve(String ownerTableAlias, String fetchedPartPath) {
            if (this.legacyFetchBuilders == null) {
                return null;
            }
            Map<String, DynamicFetchBuilderLegacy> fetchBuilders = this.legacyFetchBuilders.get(ownerTableAlias);
            if (fetchBuilders == null) {
                return null;
            }
            return fetchBuilders.get(fetchedPartPath);
        }
    }
}

