/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.from.TableGroup;

public class FromClauseAccessImpl
implements FromClauseAccess {
    private List<TableGroup> rootTableGroups;
    private Map<String, TableGroup> tableGroupBySqlAlias;
    private Map<NavigablePath, TableGroup> tableGroupByPath;

    public List<TableGroup> getRootTableGroups() {
        return this.rootTableGroups;
    }

    public TableGroup getByAlias(String alias) {
        TableGroup byAlias = this.findByAlias(alias);
        if (byAlias == null) {
            throw new IllegalArgumentException("Could not resolve TableGroup by alias [" + alias + "]");
        }
        return byAlias;
    }

    public TableGroup findByAlias(String alias) {
        TableGroup tableGroup;
        if (this.tableGroupBySqlAlias != null && (tableGroup = this.tableGroupBySqlAlias.get(alias)) != null) {
            return tableGroup;
        }
        if (this.rootTableGroups != null && this.rootTableGroups.size() == 1) {
            return this.rootTableGroups.get(0);
        }
        return null;
    }

    @Override
    public TableGroup findTableGroup(NavigablePath navigablePath) {
        TableGroup tableGroup;
        if (this.tableGroupByPath != null && (tableGroup = this.tableGroupByPath.get(navigablePath)) != null) {
            return tableGroup;
        }
        if (this.rootTableGroups != null && this.rootTableGroups.size() == 1) {
            return this.rootTableGroups.get(0);
        }
        return null;
    }

    @Override
    public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
        if (this.tableGroupByPath == null) {
            this.tableGroupByPath = new HashMap<NavigablePath, TableGroup>();
        }
        this.tableGroupByPath.put(navigablePath, tableGroup);
        if (tableGroup.getGroupAlias() != null) {
            if (this.tableGroupBySqlAlias == null) {
                this.tableGroupBySqlAlias = new HashMap<String, TableGroup>();
            }
            this.tableGroupBySqlAlias.put(tableGroup.getGroupAlias(), tableGroup);
        }
    }
}

