/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;

public class JdbcValuesMappingImpl
implements JdbcValuesMapping {
    private final List<SqlSelection> sqlSelections;
    private final List<DomainResult<?>> domainResults;

    public JdbcValuesMappingImpl(List<SqlSelection> sqlSelections, List<DomainResult<?>> domainResults) {
        this.sqlSelections = sqlSelections;
        this.domainResults = domainResults;
    }

    @Override
    public List<SqlSelection> getSqlSelections() {
        return this.sqlSelections;
    }

    @Override
    public List<DomainResult> getDomainResults() {
        return this.domainResults;
    }

    @Override
    public List<DomainResultAssembler> resolveAssemblers(AssemblerCreationState creationState) {
        ArrayList<DomainResultAssembler> assemblers = new ArrayList<DomainResultAssembler>(this.domainResults.size());
        this.domainResults.forEach(domainResult -> assemblers.add(domainResult.createResultAssembler(creationState)));
        return assemblers;
    }
}

