/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.function.BiFunction;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.MissingSqlSelectionException;
import org.hibernate.query.results.PositionalSelectionsNotAllowedException;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.complete.CompleteFetchBuilder;
import org.hibernate.query.results.complete.ModelPartReferenceBasic;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class CompleteFetchBuilderBasicPart
implements CompleteFetchBuilder,
ModelPartReferenceBasic {
    private final NavigablePath navigablePath;
    private final BasicValuedModelPart referencedModelPart;
    private final String selectionAlias;

    public CompleteFetchBuilderBasicPart(NavigablePath navigablePath, BasicValuedModelPart referencedModelPart, String selectionAlias) {
        this.navigablePath = navigablePath;
        this.referencedModelPart = referencedModelPart;
        this.selectionAlias = selectionAlias;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public BasicValuedModelPart getReferencedPart() {
        return this.referencedModelPart;
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        String selectedAlias;
        int jdbcPosition;
        DomainResultCreationStateImpl creationState = ResultsHelper.impl(domainResultCreationState);
        String mappedTable = this.referencedModelPart.getContainingTableExpression();
        String mappedColumn = this.referencedModelPart.getMappedColumnExpression();
        TableGroup tableGroup = creationState.getFromClauseAccess().getTableGroup(parent.getNavigablePath());
        TableReference tableReference = tableGroup.getTableReference(mappedTable);
        if (this.selectionAlias != null) {
            try {
                jdbcPosition = jdbcResultsMetadata.resolveColumnPosition(this.selectionAlias);
            }
            catch (Exception e) {
                throw new MissingSqlSelectionException("ResultSet mapping specified selected-alias `" + this.selectionAlias + "` which was not part of the ResultSet", e);
            }
            selectedAlias = this.selectionAlias;
        } else {
            if (!creationState.arePositionalSelectionsAllowed()) {
                throw new PositionalSelectionsNotAllowedException("Positional SQL selection resolution not allowed");
            }
            jdbcPosition = creationState.getNumberOfProcessedSelections();
            selectedAlias = jdbcResultsMetadata.resolveColumnName(jdbcPosition);
        }
        int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
        creationState.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, mappedColumn), processingState -> new SqlSelectionImpl(valuesArrayPosition, this.referencedModelPart));
        return this.referencedModelPart.generateFetch(parent, fetchPath, FetchTiming.IMMEDIATE, true, LockMode.READ, selectedAlias, domainResultCreationState);
    }
}

