/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.HashMap;
import java.util.function.BiFunction;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.ResultBuilderBasicValued;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.complete.CompleteResultBuilderEntityValued;
import org.hibernate.query.results.complete.EntityResultImpl;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class CompleteResultBuilderEntityJpa
implements CompleteResultBuilderEntityValued {
    private final NavigablePath navigablePath;
    private final EntityMappingType entityDescriptor;
    private final LockMode lockMode;
    private final ResultBuilderBasicValued discriminatorResultBuilder;
    private final HashMap<String, FetchBuilder> explicitFetchBuilderMap;

    public CompleteResultBuilderEntityJpa(NavigablePath navigablePath, EntityMappingType entityDescriptor, LockMode lockMode, ResultBuilderBasicValued discriminatorResultBuilder, HashMap<String, FetchBuilder> explicitFetchBuilderMap) {
        this.navigablePath = navigablePath;
        this.entityDescriptor = entityDescriptor;
        this.lockMode = lockMode;
        this.discriminatorResultBuilder = discriminatorResultBuilder;
        this.explicitFetchBuilderMap = explicitFetchBuilderMap;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public EntityMappingType getReferencedPart() {
        return this.entityDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityResult buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl impl = ResultsHelper.impl(domainResultCreationState);
        impl.disallowPositionalSelections();
        impl.pushExplicitFetchMementoResolver(this.explicitFetchBuilderMap::get);
        try {
            DomainResult discriminatorResult;
            impl.getFromClauseAccess().resolveTableGroup(this.navigablePath, np -> this.entityDescriptor.createRootTableGroup(this.navigablePath, null, false, this.lockMode, impl.getSqlAliasBaseManager(), impl.getSqlAstCreationState().getSqlExpressionResolver(), () -> predicate -> {}, impl.getSqlAstCreationState().getCreationContext()));
            EntityDiscriminatorMapping discriminatorMapping = this.entityDescriptor.getDiscriminatorMapping();
            if (discriminatorMapping == null) {
                assert (this.discriminatorResultBuilder == null);
                discriminatorResult = null;
            } else {
                assert (this.discriminatorResultBuilder != null);
                discriminatorResult = this.discriminatorResultBuilder.buildResult(jdbcResultsMetadata, resultPosition, (BiFunction)legacyFetchResolver, domainResultCreationState);
            }
            EntityResultImpl entityResultImpl = new EntityResultImpl(this.navigablePath, this.entityDescriptor, null, this.lockMode, (BasicResult<?>)discriminatorResult, domainResultCreationState);
            return entityResultImpl;
        }
        finally {
            impl.popExplicitFetchMementoResolver();
        }
    }
}

