/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import java.util.function.BiFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.dynamic.DynamicResultBuilderBasic;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class DynamicResultBuilderBasicStandard
implements DynamicResultBuilderBasic {
    private final String columnName;
    private final String resultAlias;
    private final BasicType<?> explicitType;
    private final JavaTypeDescriptor<?> explicitJavaTypeDescriptor;

    public DynamicResultBuilderBasicStandard(String columnName, String resultAlias) {
        assert (columnName != null);
        this.columnName = columnName;
        this.resultAlias = resultAlias != null ? resultAlias : columnName;
        this.explicitType = null;
        this.explicitJavaTypeDescriptor = null;
    }

    public DynamicResultBuilderBasicStandard(String columnName, String resultAlias, JavaTypeDescriptor<?> explicitJavaTypeDescriptor) {
        assert (columnName != null);
        this.columnName = columnName;
        String string = this.resultAlias = resultAlias != null ? resultAlias : columnName;
        assert (explicitJavaTypeDescriptor != null);
        this.explicitJavaTypeDescriptor = explicitJavaTypeDescriptor;
        this.explicitType = null;
    }

    public DynamicResultBuilderBasicStandard(String columnName, String resultAlias, BasicType<?> explicitType) {
        assert (columnName != null);
        this.columnName = columnName;
        String string = this.resultAlias = resultAlias != null ? resultAlias : columnName;
        assert (explicitType != null);
        this.explicitType = explicitType;
        this.explicitJavaTypeDescriptor = null;
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        TypeConfiguration typeConfiguration;
        BasicType<?> basicType;
        SessionFactoryImplementor sessionFactory = domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory();
        int jdbcPosition = jdbcResultsMetadata.resolveColumnPosition(this.columnName);
        int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
        if (this.explicitType != null) {
            basicType = this.explicitType;
        } else if (this.explicitJavaTypeDescriptor != null) {
            typeConfiguration = sessionFactory.getTypeConfiguration();
            SqlTypeDescriptor sqlTypeDescriptor = jdbcResultsMetadata.resolveSqlTypeDescriptor(jdbcPosition);
            basicType = typeConfiguration.getBasicTypeRegistry().resolve(this.explicitJavaTypeDescriptor, sqlTypeDescriptor);
        } else {
            typeConfiguration = sessionFactory.getTypeConfiguration();
            SqlTypeDescriptor sqlTypeDescriptor = jdbcResultsMetadata.resolveSqlTypeDescriptor(jdbcPosition);
            BasicJavaDescriptor javaTypeDescriptor = sqlTypeDescriptor.getJdbcRecommendedJavaTypeMapping(typeConfiguration);
            basicType = typeConfiguration.getBasicTypeRegistry().resolve(javaTypeDescriptor, sqlTypeDescriptor);
        }
        SqlExpressionResolver sqlExpressionResolver = domainResultCreationState.getSqlAstCreationState().getSqlExpressionResolver();
        sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(this.columnName, state -> new SqlSelectionImpl(valuesArrayPosition, basicType)), basicType.getJavaTypeDescriptor(), sessionFactory.getTypeConfiguration());
        return new BasicResult(valuesArrayPosition, this.resultAlias, this.explicitJavaTypeDescriptor);
    }
}

