/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.implicit;

import java.util.function.BiFunction;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.ConvertibleModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.implicit.ImplicitFetchBuilder;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ImplicitFetchBuilderBasic
implements ImplicitFetchBuilder {
    private final NavigablePath fetchPath;
    private final BasicValuedModelPart fetchable;

    public ImplicitFetchBuilderBasic(NavigablePath fetchPath, BasicValuedModelPart fetchable) {
        this.fetchPath = fetchPath;
        this.fetchable = fetchable;
    }

    @Override
    public BasicFetch<?> buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroup parentTableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(parent.getNavigablePath());
        String column = this.fetchable.getMappedColumnExpression();
        String table = this.fetchable.getContainingTableExpression();
        int jdbcPosition = jdbcResultsMetadata.resolveColumnPosition(column);
        int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
        Expression expression = creationStateImpl.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(parentTableGroup.getTableReference(table), column), processingState -> new SqlSelectionImpl(valuesArrayPosition, this.fetchable));
        creationStateImpl.resolveSqlSelection(expression, this.fetchable.getJavaTypeDescriptor(), domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicFetch(valuesArrayPosition, parent, fetchPath, this.fetchable, true, ((ConvertibleModelPart)((Object)this.fetchable)).getValueConverter(), FetchTiming.IMMEDIATE, domainResultCreationState);
    }

    public String toString() {
        return "ImplicitFetchBuilderBasic(" + this.fetchPath + ")";
    }
}

