/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.implicit;

import java.util.function.BiFunction;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.implicit.ImplicitFetchBuilder;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ImplicitFetchBuilderEmbeddable
implements ImplicitFetchBuilder {
    private final NavigablePath fetchPath;
    private final EmbeddableValuedFetchable fetchable;

    public ImplicitFetchBuilderEmbeddable(NavigablePath fetchPath, EmbeddableValuedFetchable fetchable) {
        this.fetchPath = fetchPath;
        this.fetchable = fetchable;
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState creationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(creationState);
        TableGroup tableGroup = creationStateImpl.getFromClauseAccess().resolveTableGroup(fetchPath, navigablePath -> {
            TableGroup parentTableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(parent.getNavigablePath());
            TableGroupJoin tableGroupJoin = this.fetchable.createTableGroupJoin(fetchPath, parentTableGroup, null, SqlAstJoinType.INNER, LockMode.READ, creationStateImpl);
            return tableGroupJoin.getJoinedGroup();
        });
        this.fetchable.visitColumns((table, column, isColumnFormula, jdbcMapping) -> {
            TableReference tableReference = tableGroup.getTableReference(table);
            int jdbcPosition = jdbcResultsMetadata.resolveColumnPosition(column);
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            Expression expression = creationStateImpl.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, column), processingState -> new SqlSelectionImpl(valuesArrayPosition, jdbcMapping));
            creationStateImpl.resolveSqlSelection(expression, jdbcMapping.getJavaTypeDescriptor(), creationStateImpl.getSessionFactory().getTypeConfiguration());
        });
        return this.fetchable.generateFetch(parent, fetchPath, FetchTiming.IMMEDIATE, true, LockMode.READ, null, creationState);
    }

    public String toString() {
        return "ImplicitFetchBuilderEmbeddable(" + this.fetchPath + ")";
    }
}

