/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.query.spi.NativeQueryInterpreter;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.hql.internal.StandardHqlTranslator;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.internal.QueryInterpretationCacheDisabledImpl;
import org.hibernate.query.internal.QueryInterpretationCacheStandardImpl;
import org.hibernate.query.named.NamedQueryRepository;
import org.hibernate.query.spi.QueryEngineOptions;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.internal.SqmCreationOptionsStandard;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.service.ServiceRegistry;
import org.jboss.logging.Logger;

@Incubating
public class QueryEngine {
    private static final Logger LOG_HQL_FUNCTIONS = CoreLogging.logger("org.hibernate.LOG_HQL_FUNCTIONS");
    private final NamedQueryRepository namedQueryRepository;
    private final SqmCriteriaNodeBuilder criteriaBuilder;
    private final HqlTranslator hqlTranslator;
    private final SqmTranslatorFactory sqmTranslatorFactory;
    private final NativeQueryInterpreter nativeQueryInterpreter;
    private final QueryInterpretationCache interpretationCache;
    private final SqmFunctionRegistry sqmFunctionRegistry;

    public static QueryEngine from(SessionFactoryImplementor sessionFactory, MetadataImplementor metadata) {
        SessionFactoryImplementor sqmCreationContext = sessionFactory;
        SessionFactoryOptions queryEngineOptions = sessionFactory.getSessionFactoryOptions();
        SqmCreationOptionsStandard sqmCreationOptions = new SqmCreationOptionsStandard(sessionFactory);
        Dialect dialect = sessionFactory.getJdbcServices().getDialect();
        HqlTranslator hqlTranslator = QueryEngine.resolveHqlTranslator(queryEngineOptions, dialect, sqmCreationContext, sqmCreationOptions);
        SqmTranslatorFactory sqmTranslatorFactory = QueryEngine.resolveSqmTranslatorFactory(queryEngineOptions, dialect);
        return new QueryEngine(() -> sessionFactory.getRuntimeMetamodels().getJpaMetamodel(), metadata.buildNamedQueryRepository(sessionFactory), hqlTranslator, sqmTranslatorFactory, sessionFactory.getServiceRegistry().getService(NativeQueryInterpreter.class), QueryEngine.buildInterpretationCache(sessionFactory.getProperties()), dialect, queryEngineOptions.getCustomSqmFunctionRegistry(), sessionFactory.getServiceRegistry());
    }

    public QueryEngine(Supplier<JpaMetamodel> jpaMetamodelAccess, NamedQueryRepository namedQueryRepository, HqlTranslator hqlTranslator, SqmTranslatorFactory sqmTranslatorFactory, NativeQueryInterpreter nativeQueryInterpreter, QueryInterpretationCache interpretationCache, Dialect dialect, SqmFunctionRegistry userDefinedRegistry, ServiceRegistry serviceRegistry) {
        boolean showSQLFunctions;
        this.namedQueryRepository = namedQueryRepository;
        this.sqmTranslatorFactory = sqmTranslatorFactory;
        this.nativeQueryInterpreter = nativeQueryInterpreter;
        this.interpretationCache = interpretationCache;
        this.hqlTranslator = hqlTranslator;
        this.criteriaBuilder = new SqmCriteriaNodeBuilder(this, jpaMetamodelAccess, serviceRegistry);
        this.sqmFunctionRegistry = new SqmFunctionRegistry();
        dialect.initializeFunctionRegistry(this);
        if (userDefinedRegistry != null) {
            userDefinedRegistry.overlay(this.sqmFunctionRegistry);
        }
        if ((showSQLFunctions = ConfigurationHelper.getBoolean("hibernate.dialect.show_hql_functions", serviceRegistry.getService(ConfigurationService.class).getSettings(), false)) && LOG_HQL_FUNCTIONS.isInfoEnabled()) {
            this.sqmFunctionRegistry.getFunctionsByName().forEach(entry -> LOG_HQL_FUNCTIONS.info((Object)((SqmFunctionDescriptor)entry.getValue()).getSignature((String)entry.getKey())));
        }
    }

    public QueryEngine(final JpaMetamodel jpaMetamodel, final boolean useStrictJpaCompliance, NamedQueryRepository namedQueryRepository, NativeQueryInterpreter nativeQueryInterpreter, Dialect dialect, final ServiceRegistry serviceRegistry) {
        this.namedQueryRepository = namedQueryRepository;
        this.sqmTranslatorFactory = null;
        this.nativeQueryInterpreter = nativeQueryInterpreter;
        this.sqmFunctionRegistry = new SqmFunctionRegistry();
        dialect.initializeFunctionRegistry(this);
        this.criteriaBuilder = new SqmCriteriaNodeBuilder(this, () -> jpaMetamodel, serviceRegistry);
        SqmCreationContext sqmCreationContext = new SqmCreationContext(){

            @Override
            public JpaMetamodel getJpaMetamodel() {
                return jpaMetamodel;
            }

            @Override
            public ServiceRegistry getServiceRegistry() {
                return serviceRegistry;
            }

            @Override
            public QueryEngine getQueryEngine() {
                return QueryEngine.this;
            }

            @Override
            public NodeBuilder getNodeBuilder() {
                return QueryEngine.this.criteriaBuilder;
            }
        };
        this.hqlTranslator = new StandardHqlTranslator(sqmCreationContext, new SqmCreationOptions(){

            @Override
            public boolean useStrictJpaCompliance() {
                return useStrictJpaCompliance;
            }
        });
        this.interpretationCache = QueryEngine.buildInterpretationCache(serviceRegistry.getService(ConfigurationService.class).getSettings());
    }

    private static HqlTranslator resolveHqlTranslator(QueryEngineOptions runtimeOptions, Dialect dialect, SqmCreationContext sqmCreationContext, SqmCreationOptions sqmCreationOptions) {
        if (runtimeOptions.getCustomHqlTranslator() != null) {
            return runtimeOptions.getCustomHqlTranslator();
        }
        if (dialect.getHqlTranslator() != null) {
            return dialect.getHqlTranslator();
        }
        return new StandardHqlTranslator(sqmCreationContext, sqmCreationOptions);
    }

    private static SqmTranslatorFactory resolveSqmTranslatorFactory(QueryEngineOptions runtimeOptions, Dialect dialect) {
        if (runtimeOptions.getCustomSqmTranslatorFactory() != null) {
            return runtimeOptions.getCustomSqmTranslatorFactory();
        }
        if (dialect.getSqmTranslatorFactory() != null) {
            return dialect.getSqmTranslatorFactory();
        }
        return new StandardSqmTranslatorFactory();
    }

    private static QueryInterpretationCache buildInterpretationCache(Map properties) {
        boolean explicitUseCache = ConfigurationHelper.getBoolean("hibernate.query.plan_cache_enabled", properties, true);
        Integer explicitMaxPlanSize = ConfigurationHelper.getInteger("hibernate.query.plan_cache_max_size", properties);
        if (explicitUseCache || explicitMaxPlanSize != null && explicitMaxPlanSize > 0) {
            int size = explicitMaxPlanSize != null ? explicitMaxPlanSize : 2048;
            return new QueryInterpretationCacheStandardImpl(size);
        }
        return QueryInterpretationCacheDisabledImpl.INSTANCE;
    }

    public void prepare(SessionFactoryImplementor sessionFactory, MetadataImplementor bootMetamodel, BootstrapContext bootstrapContext) {
        Map<String, HibernateException> errors;
        this.namedQueryRepository.prepare(sessionFactory, bootMetamodel, bootstrapContext);
        if (sessionFactory.getSessionFactoryOptions().isNamedQueryStartupCheckingEnabled() && !(errors = this.namedQueryRepository.checkNamedQueries(this)).isEmpty()) {
            StringBuilder failingQueries = new StringBuilder("Errors in named queries: ");
            String sep = "";
            for (Map.Entry<String, HibernateException> entry : errors.entrySet()) {
                QueryLogging.QUERY_MESSAGE_LOGGER.namedQueryError(entry.getKey(), entry.getValue());
                failingQueries.append(sep).append(entry.getKey());
                sep = ", ";
            }
            throw new HibernateException(failingQueries.toString());
        }
    }

    public NamedQueryRepository getNamedQueryRepository() {
        return this.namedQueryRepository;
    }

    public SqmCriteriaNodeBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public HqlTranslator getHqlTranslator() {
        return this.hqlTranslator;
    }

    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return this.sqmTranslatorFactory;
    }

    public NativeQueryInterpreter getNativeQueryInterpreter() {
        return this.nativeQueryInterpreter;
    }

    public QueryInterpretationCache getInterpretationCache() {
        return this.interpretationCache;
    }

    public SqmFunctionRegistry getSqmFunctionRegistry() {
        return this.sqmFunctionRegistry;
    }

    public void close() {
        if (this.namedQueryRepository != null) {
            this.namedQueryRepository.close();
        }
        if (this.criteriaBuilder != null) {
            this.criteriaBuilder.close();
        }
        if (this.hqlTranslator != null) {
            this.hqlTranslator.close();
        }
        if (this.interpretationCache != null) {
            this.interpretationCache.close();
        }
        if (this.sqmFunctionRegistry != null) {
            this.sqmFunctionRegistry.close();
        }
    }
}

