/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.ScrollMode;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.sql.spi.NativeSelectQueryPlan;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.StandardBasicTypes;

public class NativeSelectQueryPlanImpl<R>
implements NativeSelectQueryPlan<R> {
    private final String sql;
    private final Set<String> affectedTableNames;
    private final List<QueryParameterImplementor<?>> parameterList;
    private final JdbcValuesMappingProducer resultSetMapping;
    private final RowTransformer<R> rowTransformer;

    public NativeSelectQueryPlanImpl(String sql, Set<String> affectedTableNames, List<QueryParameterImplementor<?>> parameterList, JdbcValuesMappingProducer resultSetMapping, RowTransformer<R> rowTransformer) {
        this.sql = sql;
        this.affectedTableNames = affectedTableNames;
        this.parameterList = parameterList;
        this.resultSetMapping = resultSetMapping;
        this.rowTransformer = rowTransformer != null ? rowTransformer : RowTransformerPassThruImpl.instance();
    }

    @Override
    public List<R> performList(ExecutionContext executionContext) {
        JdbcParameterBindings jdbcParameterBindings;
        List<JdbcParameterBinder> jdbcParameterBinders;
        QueryParameterBindings queryParameterBindings = executionContext.getQueryParameterBindings();
        if (this.parameterList == null || this.parameterList.isEmpty()) {
            jdbcParameterBinders = Collections.emptyList();
            jdbcParameterBindings = JdbcParameterBindings.NO_BINDINGS;
        } else {
            jdbcParameterBinders = new ArrayList(this.parameterList.size());
            jdbcParameterBindings = new JdbcParameterBindingsImpl(this.parameterList.size());
            queryParameterBindings.visitBindings((param, binding) -> {
                JavaObjectType type = binding.getBindType();
                if (type == null) {
                    type = param.getHibernateType();
                }
                if (type == null) {
                    type = StandardBasicTypes.OBJECT_TYPE;
                }
                JdbcMapping jdbcMapping = ((BasicValuedMapping)type).getJdbcMapping();
                JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcMapping);
                jdbcParameterBinders.add(jdbcParameter);
                jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, binding.getBindValue()));
            });
        }
        JdbcSelect jdbcSelect = new JdbcSelect(this.sql, jdbcParameterBinders, this.resultSetMapping, this.affectedTableNames, Collections.emptySet());
        JdbcSelectExecutorStandardImpl executor = JdbcSelectExecutorStandardImpl.INSTANCE;
        return executor.list(jdbcSelect, jdbcParameterBindings, executionContext, this.rowTransformer, false);
    }

    @Override
    public ScrollableResultsImplementor<R> performScroll(ScrollMode scrollMode, ExecutionContext executionContext) {
        JdbcParameterBindings jdbcParameterBindings;
        List<JdbcParameterBinder> jdbcParameterBinders;
        QueryParameterBindings queryParameterBindings = executionContext.getQueryParameterBindings();
        if (this.parameterList.isEmpty()) {
            jdbcParameterBinders = Collections.emptyList();
            jdbcParameterBindings = JdbcParameterBindings.NO_BINDINGS;
        } else {
            jdbcParameterBinders = new ArrayList(this.parameterList.size());
            jdbcParameterBindings = new JdbcParameterBindingsImpl(this.parameterList.size());
            queryParameterBindings.visitBindings((param, binding) -> {
                JavaObjectType type = binding.getBindType();
                if (type == null) {
                    type = param.getHibernateType();
                }
                if (type == null) {
                    type = StandardBasicTypes.OBJECT_TYPE;
                }
                JdbcMapping jdbcMapping = ((BasicValuedMapping)type).getJdbcMapping();
                JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcMapping);
                jdbcParameterBinders.add(jdbcParameter);
                jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, binding.getBindValue()));
            });
        }
        JdbcSelect jdbcSelect = new JdbcSelect(this.sql, jdbcParameterBinders, this.resultSetMapping, this.affectedTableNames, Collections.emptySet());
        JdbcSelectExecutorStandardImpl executor = JdbcSelectExecutorStandardImpl.INSTANCE;
        return executor.scroll(jdbcSelect, scrollMode, jdbcParameterBindings, executionContext, this.rowTransformer);
    }
}

