/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.List;
import java.util.Locale;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;

public class NamedSqmFunctionDescriptor
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final String functionName;
    private final boolean useParenthesesWhenNoArgs;
    private final String argumentListSignature;

    public NamedSqmFunctionDescriptor(String functionName, boolean useParenthesesWhenNoArgs, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver) {
        this(functionName, useParenthesesWhenNoArgs, argumentsValidator, returnTypeResolver, functionName, null);
    }

    public NamedSqmFunctionDescriptor(String functionName, boolean useParenthesesWhenNoArgs, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, String name, String argumentListSignature) {
        super(name, argumentsValidator, returnTypeResolver);
        this.functionName = functionName;
        this.useParenthesesWhenNoArgs = useParenthesesWhenNoArgs;
        this.argumentListSignature = argumentListSignature;
    }

    @Override
    public String getName() {
        return this.functionName;
    }

    @Override
    public String getArgumentListSignature() {
        return this.argumentListSignature == null ? super.getArgumentListSignature() : this.argumentListSignature;
    }

    @Override
    public boolean alwaysIncludesParentheses() {
        return this.useParenthesesWhenNoArgs;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> sqlAstArguments, SqlAstWalker walker) {
        boolean useParens = this.useParenthesesWhenNoArgs || !sqlAstArguments.isEmpty();
        sqlAppender.appendSql(this.functionName);
        if (useParens) {
            sqlAppender.appendSql("(");
        }
        boolean firstPass = true;
        for (SqlAstNode sqlAstArgument : sqlAstArguments) {
            if (!firstPass) {
                sqlAppender.appendSql(", ");
            }
            sqlAstArgument.accept(walker);
            firstPass = false;
        }
        if (useParens) {
            sqlAppender.appendSql(")");
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "NamedSqmFunctionTemplate(%s)", this.functionName);
    }
}

