/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.List;
import java.util.Map;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.sql.SqmInsertTranslation;
import org.hibernate.query.sqm.sql.SqmInsertTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.sql.ast.SqlAstInsertTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcInsert;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class SimpleInsertQueryPlan
implements NonSelectQueryPlan {
    private final SqmInsertStatement sqmInsert;
    private final DomainParameterXref domainParameterXref;
    private JdbcInsert jdbcInsert;
    private FromClauseAccess tableGroupAccess;
    private Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> jdbcParamsXref;

    public SimpleInsertQueryPlan(SqmInsertStatement sqmInsert, DomainParameterXref domainParameterXref) {
        this.sqmInsert = sqmInsert;
        this.domainParameterXref = domainParameterXref;
    }

    @Override
    public int executeUpdate(ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        if (this.jdbcInsert == null) {
            QueryEngine queryEngine = factory.getQueryEngine();
            SqmTranslatorFactory translatorFactory = queryEngine.getSqmTranslatorFactory();
            SqmInsertTranslator translator = translatorFactory.createInsertTranslator(executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getLoadQueryInfluencers(), factory);
            SqmInsertTranslation sqmInterpretation = translator.translate(this.sqmInsert);
            this.tableGroupAccess = translator.getFromClauseAccess();
            this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(this.domainParameterXref, sqmInterpretation::getJdbcParamsBySqmParam);
            JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
            SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
            SqlAstInsertTranslator sqlAstTranslator = sqlAstTranslatorFactory.buildInsertTranslator(factory);
            this.jdbcInsert = sqlAstTranslator.translate(sqmInterpretation.getSqlAst());
        }
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, factory.getDomainModel(), this.tableGroupAccess::findTableGroup, executionContext.getSession());
        return jdbcServices.getJdbcMutationExecutor().execute(this.jdbcInsert, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }
}

