/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.Bindable;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.SqlAstSelectTranslator;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.jboss.logging.Logger;

public class MatchingIdSelectionHelper {
    private static final Logger log = Logger.getLogger(MatchingIdSelectionHelper.class);

    public static SelectStatement generateMatchingIdSelectStatement(EntityMappingType targetEntityDescriptor, SqmDeleteOrUpdateStatement sqmStatement, Predicate restriction, MultiTableSqmMutationConverter sqmConverter, SessionFactoryImplementor sessionFactory) {
        Bindable entityDomainType = ((SqmRoot)sqmStatement.getTarget()).getModel();
        if (log.isTraceEnabled()) {
            log.tracef("Starting generation of entity-id SQM selection - %s", (Object)entityDomainType.getHibernateEntityName());
        }
        QuerySpec idSelectionQuery = new QuerySpec(true, 1);
        TableGroup mutatingTableGroup = sqmConverter.getMutatingTableGroup();
        idSelectionQuery.getFromClause().addRoot(mutatingTableGroup);
        ArrayList<DomainResult> domainResults = new ArrayList<DomainResult>();
        MutableInteger i = new MutableInteger();
        targetEntityDescriptor.getIdentifierMapping().visitColumns((containingTableExpression, columnExpression, isColumnExpressionFormula, jdbcMapping) -> {
            int position = i.getAndIncrement();
            TableReference tableReference = mutatingTableGroup.resolveTableReference(containingTableExpression);
            Expression expression = sqmConverter.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, columnExpression), sqlAstProcessingState -> new ColumnReference(tableReference, columnExpression, isColumnExpressionFormula, jdbcMapping, sessionFactory));
            idSelectionQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(position, position + 1, expression));
            domainResults.add(new BasicResult(position, null, jdbcMapping.getJavaTypeDescriptor()));
        });
        idSelectionQuery.applyPredicate(restriction);
        return new SelectStatement(idSelectionQuery, domainResults);
    }

    public static QuerySpec generateMatchingIdSelectQuery(EntityMappingType targetEntityDescriptor, SqmDeleteOrUpdateStatement sqmStatement, DomainParameterXref domainParameterXref, Predicate restriction, MultiTableSqmMutationConverter sqmConverter, SessionFactoryImplementor sessionFactory) {
        Bindable entityDomainType = ((SqmRoot)sqmStatement.getTarget()).getModel();
        if (log.isTraceEnabled()) {
            log.tracef("Starting generation of entity-id SQM selection - %s", (Object)entityDomainType.getHibernateEntityName());
        }
        QuerySpec idSelectionQuery = new QuerySpec(true, 1);
        TableGroup mutatingTableGroup = sqmConverter.getMutatingTableGroup();
        idSelectionQuery.getFromClause().addRoot(mutatingTableGroup);
        MutableInteger i = new MutableInteger();
        targetEntityDescriptor.getIdentifierMapping().visitColumns((containingTableExpression, columnExpression, isColumnExpressionFormula, jdbcMapping) -> {
            int position = i.getAndIncrement();
            TableReference tableReference = mutatingTableGroup.resolveTableReference(containingTableExpression);
            Expression expression = sqmConverter.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, columnExpression), sqlAstProcessingState -> new ColumnReference(tableReference, columnExpression, isColumnExpressionFormula, jdbcMapping, sessionFactory));
            idSelectionQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(position, position + 1, expression));
        });
        idSelectionQuery.applyPredicate(restriction);
        return idSelectionQuery;
    }

    public static List<Object> selectMatchingIds(SqmDeleteOrUpdateStatement sqmMutationStatement, DomainParameterXref domainParameterXref, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        EntityPersister entityDescriptor = factory.getDomainModel().getEntityDescriptor(((SqmRoot)sqmMutationStatement.getTarget()).getModel().getHibernateEntityName());
        MultiTableSqmMutationConverter sqmConverter = new MultiTableSqmMutationConverter(entityDescriptor, ((AbstractSqmFrom)((Object)sqmMutationStatement.getTarget())).getExplicitAlias(), domainParameterXref, executionContext.getQueryOptions(), executionContext.getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), factory);
        Map parameterResolutions = domainParameterXref.getSqmParameterCount() == 0 ? Collections.emptyMap() : new IdentityHashMap();
        Predicate restriction = sqmConverter.visitWhereClause(sqmMutationStatement.getWhereClause(), columnReference -> {}, parameterResolutions::put);
        SelectStatement matchingIdSelection = MatchingIdSelectionHelper.generateMatchingIdSelectStatement(entityDescriptor, sqmMutationStatement, restriction, sqmConverter, factory);
        JdbcServices jdbcServices = factory.getJdbcServices();
        SqlAstSelectTranslator sqlAstSelectTranslator = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(factory);
        JdbcSelect idSelectJdbcOperation = sqlAstSelectTranslator.translate(matchingIdSelection);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), domainParameterXref, SqmUtil.generateJdbcParamsXref(domainParameterXref, sqmConverter), factory.getDomainModel(), navigablePath -> sqmConverter.getMutatingTableGroup(), executionContext.getSession());
        return jdbcServices.getJdbcSelectExecutor().list(idSelectJdbcOperation, jdbcParameterBindings, executionContext, row -> row, true);
    }
}

