/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableColumn;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableExporter;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableHelper;
import org.hibernate.sql.ast.SqlAstInsertTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcInsert;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.UUIDCharType;
import org.jboss.logging.Logger;

public final class ExecuteWithIdTableHelper {
    private static final Logger log = Logger.getLogger(ExecuteWithIdTableHelper.class);
    public static final boolean debugging = log.isDebugEnabled();

    private ExecuteWithIdTableHelper() {
    }

    public static int saveMatchingIdsIntoIdTable(MultiTableSqmMutationConverter sqmConverter, Predicate suppliedPredicate, IdTable idTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        TableGroup mutatingTableGroup = sqmConverter.getMutatingTableGroup();
        assert (mutatingTableGroup.getModelPart() instanceof EntityMappingType);
        EntityMappingType mutatingEntityDescriptor = (EntityMappingType)mutatingTableGroup.getModelPart();
        InsertStatement idTableInsert = new InsertStatement();
        TableReference idTableReference = new TableReference(idTable.getTableExpression(), null, false, factory);
        idTableInsert.setTargetTable(idTableReference);
        for (int i = 0; i < idTable.getIdTableColumns().size(); ++i) {
            IdTableColumn column = idTable.getIdTableColumns().get(i);
            idTableInsert.addTargetColumnReferences(new ColumnReference(idTableReference, column.getColumnName(), false, column.getJdbcMapping(), factory));
        }
        QuerySpec matchingIdSelection = new QuerySpec(true, 1);
        idTableInsert.setSourceSelectStatement(matchingIdSelection);
        matchingIdSelection.getFromClause().addRoot(mutatingTableGroup);
        MutableInteger positionWrapper = new MutableInteger();
        mutatingEntityDescriptor.getIdentifierMapping().visitColumns((containingTableExpression, columnExpression, isColumnExpressionFormula, jdbcMapping) -> {
            int jdbcPosition = positionWrapper.getAndIncrement();
            TableReference tableReference = mutatingTableGroup.resolveTableReference(containingTableExpression);
            matchingIdSelection.getSelectClause().addSqlSelection(new SqlSelectionImpl(jdbcPosition, jdbcPosition + 1, sqmConverter.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, columnExpression), sqlAstProcessingState -> new ColumnReference(tableReference, columnExpression, isColumnExpressionFormula, jdbcMapping, factory))));
        });
        if (idTable.getSessionUidColumn() != null) {
            int jdbcPosition = positionWrapper.getAndIncrement();
            matchingIdSelection.getSelectClause().addSqlSelection(new SqlSelectionImpl(jdbcPosition, jdbcPosition + 1, new QueryLiteral<String>(sessionUidAccess.apply(executionContext.getSession()), StandardBasicTypes.STRING)));
        }
        matchingIdSelection.applyPredicate(suppliedPredicate);
        JdbcServices jdbcServices = factory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        SqlAstInsertTranslator sqlAstTranslator = sqlAstTranslatorFactory.buildInsertTranslator(factory);
        JdbcInsert jdbcInsert = sqlAstTranslator.translate(idTableInsert);
        jdbcInsert.bindFilterJdbcParameters(jdbcParameterBindings);
        return jdbcServices.getJdbcMutationExecutor().execute(jdbcInsert, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }

    public static QuerySpec createIdTableSelectQuerySpec(IdTable idTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, EntityMappingType entityDescriptor, ExecutionContext executionContext) {
        QuerySpec querySpec = new QuerySpec(false);
        TableReference idTableReference = new TableReference(idTable.getTableExpression(), null, true, executionContext.getSession().getFactory());
        StandardTableGroup idTableGroup = new StandardTableGroup(new NavigablePath(idTableReference.getTableExpression()), entityDescriptor, LockMode.NONE, idTableReference, Collections.emptyList(), null, executionContext.getSession().getFactory());
        querySpec.getFromClause().addRoot(idTableGroup);
        ExecuteWithIdTableHelper.applyIdTableSelections(querySpec, idTableReference, idTable, executionContext);
        ExecuteWithIdTableHelper.applyIdTableRestrictions(querySpec, idTableReference, idTable, sessionUidAccess, executionContext);
        return querySpec;
    }

    private static void applyIdTableSelections(QuerySpec querySpec, TableReference tableReference, IdTable idTable, ExecutionContext executionContext) {
        for (int i = 0; i < idTable.getIdTableColumns().size(); ++i) {
            IdTableColumn idTableColumn = idTable.getIdTableColumns().get(i);
            if (idTableColumn == idTable.getSessionUidColumn()) continue;
            querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(i + 1, i, new ColumnReference(tableReference, idTableColumn.getColumnName(), false, idTableColumn.getJdbcMapping(), executionContext.getSession().getFactory())));
        }
    }

    private static void applyIdTableRestrictions(QuerySpec querySpec, TableReference idTableReference, IdTable idTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, ExecutionContext executionContext) {
        if (idTable.getSessionUidColumn() != null) {
            querySpec.applyPredicate(new ComparisonPredicate(new ColumnReference(idTableReference, idTable.getSessionUidColumn().getColumnName(), false, idTable.getSessionUidColumn().getJdbcMapping(), executionContext.getSession().getFactory()), ComparisonOperator.EQUAL, new QueryLiteral<String>(sessionUidAccess.apply(executionContext.getSession()), UUIDCharType.INSTANCE)));
        }
    }

    public static void performBeforeIdTableUseActions(BeforeUseAction beforeUseAction, IdTable idTable, Supplier<IdTableExporter> idTableExporterAccess, TempTableDdlTransactionHandling ddlTransactionHandling, ExecutionContext executionContext) {
        if (beforeUseAction == BeforeUseAction.CREATE) {
            IdTableHelper.IdTableCreationWork idTableCreationWork = new IdTableHelper.IdTableCreationWork(idTable, idTableExporterAccess.get(), executionContext.getSession().getFactory());
            if (ddlTransactionHandling == TempTableDdlTransactionHandling.NONE) {
                executionContext.getSession().doWork(idTableCreationWork);
            } else {
                IsolationDelegate isolationDelegate = executionContext.getSession().getJdbcCoordinator().getJdbcSessionOwner().getTransactionCoordinator().createIsolationDelegate();
                isolationDelegate.delegateWork(idTableCreationWork, ddlTransactionHandling == TempTableDdlTransactionHandling.ISOLATE_AND_TRANSACT);
            }
        }
    }

    public static void performAfterIdTableUseActions(AfterUseAction afterUseAction, IdTable idTable, Supplier<IdTableExporter> idTableExporterAccess, TempTableDdlTransactionHandling ddlTransactionHandling, Function<SharedSessionContractImplementor, String> sessionUidAccess, ExecutionContext executionContext) {
        if (afterUseAction == AfterUseAction.CLEAN) {
            IdTableHelper.cleanIdTableRows(idTable, idTableExporterAccess.get(), sessionUidAccess, executionContext.getSession());
        } else if (afterUseAction == AfterUseAction.DROP) {
            IdTableHelper.IdTableDropWork idTableDropWork = new IdTableHelper.IdTableDropWork(idTable, idTableExporterAccess.get(), executionContext.getSession().getFactory());
            if (ddlTransactionHandling == TempTableDdlTransactionHandling.NONE) {
                executionContext.getSession().doWork(idTableDropWork);
            } else {
                IsolationDelegate isolationDelegate = executionContext.getSession().getJdbcCoordinator().getJdbcSessionOwner().getTransactionCoordinator().createIsolationDelegate();
                isolationDelegate.delegateWork(idTableDropWork, ddlTransactionHandling == TempTableDdlTransactionHandling.ISOLATE_AND_TRANSACT);
            }
        }
    }
}

