/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableColumn;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableSessionUidColumn;

public class IdTable
implements Exportable {
    private final EntityMappingType entityDescriptor;
    private final String qualifiedTableName;
    private IdTableSessionUidColumn sessionUidColumn;
    private final List<IdTableColumn> columns = new ArrayList<IdTableColumn>();

    public IdTable(EntityMappingType entityDescriptor, Function<String, String> idTableNameAdjuster) {
        this.entityDescriptor = entityDescriptor;
        this.qualifiedTableName = idTableNameAdjuster.apply(((Joinable)((Object)entityDescriptor.getEntityPersister())).getTableName());
        entityDescriptor.getIdentifierMapping().visitColumns((containingTableExpression, columnExpression, isColumnExpressionFormula, jdbcMapping) -> this.columns.add(new IdTableColumn(this, columnExpression, jdbcMapping)));
    }

    public EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public String getQualifiedTableName() {
        return this.qualifiedTableName;
    }

    public List<IdTableColumn> getIdTableColumns() {
        return this.columns;
    }

    public IdTableSessionUidColumn getSessionUidColumn() {
        return this.sessionUidColumn;
    }

    public String getTableExpression() {
        return this.qualifiedTableName;
    }

    public void addColumn(IdTableColumn column) {
        this.columns.add(column);
        if (column instanceof IdTableSessionUidColumn) {
            this.sessionUidColumn = (IdTableSessionUidColumn)column;
        }
    }

    @Override
    public String getExportIdentifier() {
        return this.getQualifiedTableName();
    }
}

