/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlAstQuerySpecProcessingState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class SqlAstQuerySpecProcessingStateImpl
extends SqlAstProcessingStateImpl
implements SqlAstQuerySpecProcessingState {
    private final QuerySpec querySpec;
    private Map<Expression, SqlSelection> sqlSelectionMap;

    public SqlAstQuerySpecProcessingStateImpl(QuerySpec querySpec, SqlAstProcessingState parent, SqlAstCreationState creationState, Supplier<Clause> currentClauseAccess) {
        super(parent, creationState, currentClauseAccess);
        this.querySpec = querySpec;
    }

    @Override
    public QuerySpec getInflightQuerySpec() {
        return this.querySpec;
    }

    @Override
    protected Map<Expression, SqlSelection> sqlSelectionMap() {
        return this.sqlSelectionMap;
    }

    @Override
    public SqlSelection resolveSqlSelection(Expression expression, JavaTypeDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        SqlSelection existing;
        if (this.sqlSelectionMap == null) {
            this.sqlSelectionMap = new HashMap<Expression, SqlSelection>();
            existing = null;
        } else {
            existing = this.sqlSelectionMap.get(expression);
        }
        if (existing != null) {
            return existing;
        }
        int valuesArrayPosition = this.sqlSelectionMap.size();
        SqlSelection sqlSelection = expression.createSqlSelection(valuesArrayPosition + 1, valuesArrayPosition, javaTypeDescriptor, typeConfiguration);
        this.sqlSelectionMap.put(expression, sqlSelection);
        this.querySpec.getSelectClause().addSqlSelection(sqlSelection);
        return sqlSelection;
    }
}

